#ifndef SETTING_CONFIG_H
#define SETTING_CONFIG_H

/*!
  \file
  \brief XML 設定ファイルの管理

  \author Satofumi KAMIMURA

  $Id$
*/

#include <memory>
#include <QMap>
#include <QString>


/*!
  \brief XML 設定ファイルの管理クラス
*/
class SettingConfig {

  SettingConfig(void);
  SettingConfig(const SettingConfig& rhs);
  SettingConfig& operator = (const SettingConfig& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

 public:

  /*!
    \brief コンストラクタ

    \param config_file [i] 設定の XML ファイル
  */
  explicit SettingConfig(const std::string& config_file);


  /*!
    \brief コンストラクタ

    \param tags [o] タグ情報の格納先
    \param data [i] XML データ配列
  */
  explicit SettingConfig(QMap<QString, QString>& tags, QByteArray& data);
  ~SettingConfig(void);


  /*!
    \brief 値の取得

    \param tag [i] タグ

    \retval 値
  */
  const std::string getValue(const std::string& tag);


  /*!
    \brief 値の設定

    \param tag [i] タグ
    \param value [i] 値
  */
  void setValue(const std::string& tag, const std::string& value);


  /*!
    \brief アーカイブファイルの更新

    \retval true 正常
    \retval false エラー
  */
  void save(void);
};

#endif /* !SETTING_CONFIG_H */
