/*!
  \file
  \brief テーマ時計のリソース

  \author Satofumi KAMIMURA

  $Id$
*/

#include <QString>
#include <QPoint>
#include <QVector>
#include "ThemeResource.h"


namespace {
  // デジタル文字の描画位置を設定
  void digitalPositionUpdate(QVector<QPoint>& digital_positions,
                             int index, const QMap<QString, QString>& tags,
                             const QString& x_tag, const QString& y_tag) {

    int x = tags.value(x_tag, 0).toInt();
    int y = tags.value(y_tag, 0).toInt();
    digital_positions[index] = QPoint(x, y);
  }
};


// デジタル画像の描画位置を読み出し
void loadDigitalPosition(QVector<QPoint>& digital_positions,
                         const QMap<QString, QString>& tags) {

  // "hh:mm ss x";
  digital_positions.clear();
  digital_positions.resize(10);

  digitalPositionUpdate(digital_positions,
                        0, tags, "digital/h1_xpos", "digital/h1_ypos");
  digitalPositionUpdate(digital_positions,
                        1, tags, "digital/h2_xpos", "digital/h2_ypos");

  digitalPositionUpdate(digital_positions,
                        2, tags, "digital/cl_xpos", "digital/cl_ypos");

  digitalPositionUpdate(digital_positions,
                        3, tags, "digital/m1_xpos", "digital/m1_ypos");
  digitalPositionUpdate(digital_positions,
                        4, tags, "digital/m2_xpos", "digital/m2_ypos");

  digitalPositionUpdate(digital_positions,
                        6, tags, "digital/s1_xpos", "digital/s1_ypos");
  digitalPositionUpdate(digital_positions,
                        7, tags, "digital/s2_xpos", "digital/s2_ypos");

  digitalPositionUpdate(digital_positions,
                        9, tags, "digital/ap_xpos", "digital/ap_ypos");
}
