#ifndef THEME_RESOURCE_H
#define THEME_RESOURCE_H

/*!
  \file
  \brief テーマ時計のリソース

  \author Satofumi KAMIMURA

  $Id$
*/

#include <QMap>

class QString;
class QPixmap;
class QRect;


/*!
  \brief テーマ時計のリソース
*/
class ThemeResource {
public:
  QMap<QString, QPixmap*> pixmap; //!< 画像
  QMap<QString, QRect> offset;    //!< 位置文字
  QMap<QString, QString> option;  //!< オプション文字
};


/*!
  \brief デジタル位置の設定を読み出し

  \param digital_positions [i] デジタル文字位置
  \param tags [i] 配置情報リソース
*/
extern void loadDigitalPosition(QVector<QPoint>& digital_positions,
                                const QMap<QString, QString>& tags);

#endif /* !THEME_RESOURCE_H */
