/*!
  \file
  \brief テーマ時計のリソース

  \author Satofumi KAMIMURA

  $Id$
*/

#include <QPoint>
#include <QVector>
#include <QPixmap>
#include "ThemeResource.h"


namespace {

  // デジタル文字の描画位置を設定
  void digitalPositionUpdate(QVector<QPoint>& digital_positions,
                             int index,
                             const QMap<std::string, std::string>& tags,
                             const std::string& x_tag,
                             const std::string& y_tag) {

    int x = atoi(tags.value(x_tag, "0").c_str());
    int y = atoi(tags.value(y_tag, "0").c_str());
    digital_positions[index] = QPoint(x, y);
  }
};


// デジタル画像の描画位置を読み出し
void loadDigitalPosition(QVector<QPoint>& digital_positions,
                         const QMap<std::string, std::string>& tags) {

  // "hh:mm ss x";
  digital_positions.clear();
  digital_positions.resize(10);

  digitalPositionUpdate(digital_positions,
                        0, tags, "digital/h1_xpos", "digital/h1_ypos");
  digitalPositionUpdate(digital_positions,
                        1, tags, "digital/h2_xpos", "digital/h2_ypos");

  digitalPositionUpdate(digital_positions,
                        2, tags, "digital/cl_xpos", "digital/cl_ypos");

  digitalPositionUpdate(digital_positions,
                        3, tags, "digital/m1_xpos", "digital/m1_ypos");
  digitalPositionUpdate(digital_positions,
                        4, tags, "digital/m2_xpos", "digital/m2_ypos");

  digitalPositionUpdate(digital_positions,
                        6, tags, "digital/s1_xpos", "digital/s1_ypos");
  digitalPositionUpdate(digital_positions,
                        7, tags, "digital/s2_xpos", "digital/s2_ypos");

  digitalPositionUpdate(digital_positions,
                        9, tags, "digital/ap_xpos", "digital/ap_ypos");
}


void loadDigitalPosition(QVector<QPoint>& digital_positions,
                         QMap<std::string, QPoint>& parts_positions) {

  digital_positions.resize(10);

  digital_positions[0] = parts_positions["digital/h1"];
  digital_positions[1] = parts_positions["digital/h2"];
  digital_positions[2] = parts_positions["digital/cl"];
  digital_positions[3] = parts_positions["digital/m1"];
  digital_positions[4] = parts_positions["digital/m2"];
  digital_positions[6] = parts_positions["digital/s1"];
  digital_positions[7] = parts_positions["digital/s2"];
  digital_positions[9] = parts_positions["digital/ap"];
}
