/*!
  \file
  \brief テーマ時計の設定ダイアログ

  \author Satofumi KAMIMURA

  $Id$

  \todo シグナルを定義する
*/

#include "ClockSettingDialog.h"


struct ClockSettingDialog::pImpl {

  void initializeForm(ClockSettingDialog* parent) {

    // アイコンの適用
    parent->setWindowIcon(QIcon(":icons/qtmclock_config_icon"));

    // 拡大率の変更
    connect(parent->scale_slider_, SIGNAL(valueChanged(int)),
            parent, SLOT(scalingSliderHandler(int)));
  }
};


ClockSettingDialog::ClockSettingDialog(QDialog* parent)
  : QDialog(parent), pimpl(new pImpl) {
  setupUi(this);

  pimpl->initializeForm(this);
}


ClockSettingDialog::~ClockSettingDialog(void) {
}


void ClockSettingDialog::scalingSliderHandler(int value) {

  scale_percent_label_->setText(QString(tr("%1 %")).arg(value));

  emit scalingValueChanged(value);
}


void ClockSettingDialog::setScalingPercent(int value) {

  scale_slider_->setValue(value);
}
