/*!
  \file
  \brief std::string 文字列への変換

  \author Satofumi KAMIMURA

  $Id$

  \todo Windows 2000 環境でも動作するようにする
  \todo OS の検出とかの処理を to, from で共通にする
*/

#include <QString>
#ifdef Q_WS_WIN
#include <QLocale>
#include <QTextCodec>
#include <QSysInfo>
#endif
#include "ConvertStdStringPath.h"


const QString qrk::toStdStringPath(const QString& text) {

#ifdef Q_WS_WIN

  if (QLocale::system().name().compare("ja_JP")) {
    // 日本語ロケールでない
    return text;
  }

  QSysInfo::WinVersion version = QSysInfo::windowsVersion();

  if (version == QSysInfo::WV_XP) {
    // 日本語ロケールの場合、SJIS に変換する
    QTextCodec* codec = QTextCodec::codecForName("Shift-JIS");
    return codec->fromUnicode(text);

  } else {
    return text;
  }
#else
  return text;
#endif
}


const QString qrk::fromStdStringPath(const std::string& text) {

#ifdef Q_WS_WIN

  if (QLocale::system().name().compare("ja_JP")) {
    // 日本語ロケールでない
    return text.c_str();
  }

  QSysInfo::WinVersion version = QSysInfo::windowsVersion();

  if (version == QSysInfo::WV_XP) {
    // 日本語ロケールの場合、SJIS と見なして変換する
    QTextCodec* codec = QTextCodec::codecForName("Shift-JIS");
    return codec->toUnicode(text.c_str());

  } else {
    return text.c_str();
  }
#else
  return text.c_str();
#endif
}
