#ifndef RRDA_ENCODER_H
#define RRDA_ENCODER_H

/*!
  \file
  \brief RRDA リソースのエンコード

  \author Satofumi KAMIMURA

  $Id$
*/

#include <memory>
#include <vector>
#include <string>

class RrdaResource;


/*!
  \brief RRDA リソースのエンコード
*/
class RrdaEncoder {
  RrdaEncoder(void);
  RrdaEncoder(const RrdaEncoder& rhs);
  RrdaEncoder& operator = (const RrdaEncoder& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

public:

  /*!
    \brief コンストラクタ

    \param fileName [i] リソースファイル
    \param key [i] キー
  */
  explicit RrdaEncoder(const char* fileName, const char* key);
  ~RrdaEncoder(void);


  /*!
    \brief エラー文字列の取得

    \return エラー文字列
  */
  const char* what(void) const;


  /*!
    \brief リソース名の一覧を返す

    \return リソース名の一覧
  */
  void getResourceNames(std::vector<std::string>& names);

  /*!
    \brief リソースを返す

    \param resource_name [i] リソース名

    \return RrdaResouce オブジェクト
  */
  RrdaResource* getResource(const char* resource_name);
};

#endif /* !RRDA_ENCODER_H */
