#ifndef PARTS_PLACE_SCENE_H
#define PARTS_PLACE_SCENE_H

/*!
  \file
  \brief 配置部品の閲覧用

  \author Satofumi KAMIMURA

  $Id$
*/

#include <QGraphicsScene>


/*!
  \brief 部品配置の閲覧シーンクラス
*/
class PartsPlaceScene : public QGraphicsScene {
  Q_OBJECT;

  PartsPlaceScene(const PartsPlaceScene& rhs);
  PartsPlaceScene& operator = (const PartsPlaceScene& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

protected:
  void mousePressEvent(QGraphicsSceneMouseEvent *mouseEvent);

public:
  PartsPlaceScene(QObject* parent = 0);
  ~PartsPlaceScene(void);

signals:
  void clicked(int x, int y);
};

#endif /* !PARTS_PLACE_SCENE_H */
