#ifndef RRDA_DECODER_H
#define RRDA_DECODER_H

/*!
  \file
  \brief RRDA リソースのデコード

  \author Satofumi KAMIMURA

  $Id$
*/

#include <memory>


/*!
  \brief RRDA リソースのデコード
*/
class RrdaDecoder {
  RrdaDecoder(void);
  RrdaDecoder(const RrdaDecoder& rhs);
  RrdaDecoder& operator = (const RrdaDecoder& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

public:

  /*!
    \brief コンストラクタ

    \param fileName [i] リソースファイル
    \param key [i] キー
  */
  explicit RrdaDecoder(const std::string& fileName, const std::string& key);
  ~RrdaDecoder(void);


  /*!
    \brief リリースデータの登録

    \param tag [i] タグ
    \param file [i] データファイル名
  */
  void setNormalData(const std::string& tag, const std::string& file);


  /*!
    \brief リリースデータの登録 (制限データ)

    \param tag [i] タグ
    \param file [i] データファイル名
  */
  void setRestrictData(const std::string& tag, const std::string& file);


  /*!
    \brief リリースファイルの作成

    \retval true 正常
    \retval false エラー
  */
  bool release(void);
};

#endif /* !RRDA_DECODER_H */
