/*!
  \file
  \brief qtmclock 用の部品画像を生成する補助ツール

  \author Satofumi KAMIMURA

  $Id: parts_generator.cpp 263 2009-01-30 14:48:10Z satofumi $
*/

#include "PartsGeneratorWindow.h"
#include <QApplication>
#include <QTranslator>


namespace
{
  typedef struct
  {
    QString config_file;
  } options_t;
}


// オプション処理
static options_t optionHandler(int argc, char *argv[])
{
  options_t options;

  for (int i = 1; i < argc; ++i) {
    options.config_file = argv[i];
  }

  return options;
}


//! メイン
int main(int argc, char *argv[])
{
  QApplication app(argc, argv);

  // ロケールの適用
  QString locale = QLocale::system().name();
  QTranslator translator;
  translator.load("parts_generator_" + locale);
  app.installTranslator(&translator);

  // オプションの解析
  const options_t option = optionHandler(argc, argv);

  // アプリケーションの起動
  PartsGeneratorWindow window(option.config_file);
  window.show();
  return app.exec();
}
