#ifndef ANIMATION_MANATGER_H
#define ANIMATION_MANATGER_H

/*!
  \file
  \brief アニメーション管理

  \author Satofumi KAMIMURA

  $Id: AnimationManager.h 276 2009-10-22 03:44:32Z satofumi $
*/

#include <QObject>
#include <memory>
#include <vector>

class AnimationPattern;


/*!
  \brief アニメーション管理クラス
*/
class AnimationManager : public QObject
{
  Q_OBJECT;

public:

  /*!
    \brief コンストラクタ

    \param[in] cycle_msec 制御周期 [msec]
    \param[in] patterns アニメーション再生パターン
    \param[in] parent 親オブジェクト
  */
  AnimationManager(size_t cycle_msec,
                   const std::vector<AnimationPattern>& patterns,
                   QObject* parent = 0);
  ~AnimationManager(void);


  /*!
    \brief 評価
  */
  void evaluate(void);

signals:
  /*!
    \brief セルの更新

    \param[in] cell_index 描画するセル
  */
  void updateCell(int cell_index);

private slots:
  void updateAnimation(void);

private:
  AnimationManager(const AnimationManager& rhs);
  AnimationManager& operator = (const AnimationManager& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;
};

#endif /* !ANIMATION_MANATGER_H */
