/*!
  \file
  \brief パターンの登録ウィジット

  \author Satofumi KAMIMURA

  $Id: PatternRegisterWidget.cpp 261 2009-01-22 06:48:10Z satofumi $

  \todo イベントを接続する方法について再確認する
*/

#include "PatternRegisterWidget.h"

using namespace std;


struct PatternRegisterWidget::pImpl
{
  int index_;

  pImpl(void) : index_(0)
  {
  }
};


PatternRegisterWidget::PatternRegisterWidget(QWidget* parent)
  : QWidget(parent), pimpl(new pImpl)
{
  setupUi(this);

  // パターンの入力マスク
  QRegExp rx("[, \t0-9]+");
  pattern_edit_->setValidator(new QRegExpValidator(rx, this));

  // イベント接続
  connect(probability_spinbox_, SIGNAL(valueChanged(double)),
          this, SLOT(probabilityChangedHandler(double)));
  connect(cycle_spinbox_, SIGNAL(valueChanged(int)),
          this, SLOT(cycleChangedHandler(int)));
  connect(pattern_edit_, SIGNAL(textEdited(const QString&)),
          this, SLOT(patternChangedHandler(const QString&)));
}


PatternRegisterWidget::~PatternRegisterWidget(void)
{
}


void PatternRegisterWidget::setName(const string& name, int index)
{
  groupbox_->setTitle(name.c_str());
  pimpl->index_ = index;
}


void PatternRegisterWidget::setProbability(double probability)
{
  probability_spinbox_->setValue(probability);
}


void PatternRegisterWidget::setCycle(size_t msec)
{
  cycle_spinbox_->setValue(msec);
}


void PatternRegisterWidget::setPattern(const string& pattern)
{
  pattern_edit_->setText(pattern.c_str());
}


void PatternRegisterWidget::probabilityChangedHandler(double value)
{
  emit probabilityChanged(pimpl->index_, value);
}


void PatternRegisterWidget::cycleChangedHandler(int value)
{
  emit cycleChanged(pimpl->index_, value);
}


void PatternRegisterWidget::patternChangedHandler(const QString& text)
{
  emit patternChanged(pimpl->index_, text.toStdString());
}
