#ifndef PATTERN_REGISTER_WIDGET_H
#define PATTERN_REGISTER_WIDGET_H

/*!
  \file
  \brief パターンの登録ウィジット

  \author Satofumi KAMIMURA

  $Id: PatternRegisterWidget.h 262 2009-01-30 13:25:37Z satofumi $
*/

#include "ui_PatternRegisterWidgetForm.h"
#include <QWidget>
#include <memory>


/*!
  \brief アニメーションパターンの登録ウィジット
*/
class PatternRegisterWidget
  : public QWidget, private Ui::PatternRegisterWidgetForm
{
  Q_OBJECT;

  PatternRegisterWidget(const PatternRegisterWidget& rhs);
  PatternRegisterWidget& operator = (const PatternRegisterWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

private slots:
  void probabilityChangedHandler(double value);
  void cycleChangedHandler(int value);
  void patternChangedHandler(const QString& text);

public:
  /*!
    \brief コンストラクタ

    \param[in] parent 親ウィジット
  */
  PatternRegisterWidget(QWidget* parent = 0);
  ~PatternRegisterWidget(void);


  /*!
    \brief パターン名の登録

    \param[in] name パターン名
    \param[in] index パターンのインデックス
  */
  void setName(const std::string& name, int index);


  /*!
    \brief 発生確率の登録

    \param[in] probability 発生確率 / 秒
  */
  void setProbability(double probability);


  /*!
    \brief 描画周期の登録

    \param[in] msec ミリ秒
  */
  void setCycle(size_t msec);


  /*!
    \brief パターンの登録

    \param[in] pattern 再生パターン
  */
  void setPattern(const std::string& pattern);

signals:

  /*!
    \brief 確率の変更

    \param[in] index パターンのインデックス
    \param[in] probability 秒あたりの発生確率
  */
  void probabilityChanged(int index, double probability);


  /*!
    \brief 再生周期の変更

    \param[in] index パターンのインデックス
    \param[in] cycle_msec 再生周期 [msec]
  */
  void cycleChanged(int index, int cycle_msec);

  /*!
    \brief 再生パターンの変更

    \param[in] index パターンのインデックス
    \param[in] pattern パターンの CSV 文字列
  */
  void patternChanged(int index, const std::string& pattern);
};

#endif /* !PATTERN_REGISTER_WIDGET_H */
