/*!
  \file
  \brief qtmclock 用テーマの作成アプリケーション

  \author Satofumi KAMIMURA

  $Id: qtmclock_config.cpp 263 2009-01-30 14:48:10Z satofumi $
*/

#include "ThemeConfigWindow.h"
#include <QApplication>
#include <QTranslator>
#include <QLocale>
#include <iostream>

using namespace std;


// 使い方の表示
static void printHelp(const char* program_name)
{
  const QString message =
    QString("usage:\n"
            "\t%1 [options]\n"
            "\n"
            "options\n"
            "  --help, -h                  print this message.\n"
            "  <config file>               Specify the config file.\n"
            "  --geometry <position>       Place to <position>.\n"
            "\n"
            "Report bugs to <satofumi@users.sourceforge.jp>.")
    .arg(program_name);

  cout << message.toStdString() << endl;
}


// オプション処理
static QString optionHandler(int argc, char *argv[])
{
  // デフォルト設定
  QString config_file = "";

  if (argc > 1) {
    // 引数があれば、とりあえずそれをテーマファイル名として登録する
    // 最初の引数をテーマとみなすのは、qt パラメータとの場合分けが困難なため
    config_file = argv[1];
  }
  for (int i = 1; i < argc; ++i) {
    if ((! strcmp("--help", argv[i])) || (! strcmp("-h", argv[i]))) {
      printHelp(argv[0]);
      exit(1);
    }
  }
  return config_file;
}


//! メイン関数
int main(int argc, char *argv[])
{
  QApplication app(argc, argv);

  // ロケールの適用
  QString locale = QLocale::system().name();
  QTranslator translator;
  translator.load("qtmclock_config_" + locale);
  app.installTranslator(&translator);

  // オプションの解析
  const QString config_file = optionHandler(argc, argv);

  ThemeConfigWindow window(config_file);
  window.show();
  return app.exec();
}
