#ifndef RRDA_RESOURCE_H
#define RRDA_RESOURCE_H

/*!
  \file
  \brief RRDA のリソース管理

  \author Satofumi KAMIMURA

  $Id: RrdaResource.h 276 2009-10-22 03:44:32Z satofumi $
*/

#include <fstream>
#include <memory>


/*!
  \brief RRDA のリソース管理
*/
class RrdaResource
{
public:
  /*!
    \brief コンストラクタ

    \param[in] fin 圧縮ファイル位置の読み出しストリーム
    \param[in] size 圧縮ファイルのサイズ
  */
  explicit RrdaResource(std::ifstream& fin, size_t size);
  ~RrdaResource(void);


  /*!
    \brief メモリの先頭アドレスを返す

    \param[out] size リソースのサイズ [byte]

    \return メモリの先頭アドレス
  */
  unsigned char* get(size_t* size = NULL);

private:
  RrdaResource(void);
  RrdaResource(const RrdaResource& rhs);
  RrdaResource& operator = (const RrdaResource& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;
};

#endif /* !RRDA_RESOURCE_H */
