/*!
  \file
  \brief 配置部品の閲覧用

  \author Satofumi KAMIMURA

  $Id: PartsPlaceScene.cpp 263 2009-01-30 14:48:10Z satofumi $
*/

#include "PartsPlaceScene.h"
#include <QGraphicsSceneMouseEvent>


PartsPlaceScene::PartsPlaceScene(QObject* parent) : QGraphicsScene(parent)
{
}


PartsPlaceScene::~PartsPlaceScene(void)
{
}


void PartsPlaceScene::mousePressEvent(QGraphicsSceneMouseEvent *mouseEvent)
{
  if (mouseEvent->button() != Qt::LeftButton) {
    // 左クリック以外ならば、戻る
    return;
  }

  // クリック位置を取得
  QPointF point = mouseEvent->scenePos();

  // シグナルを投げる
  emit clicked(static_cast<int>(point.x()), static_cast<int>(point.y()));
}
