/*!
  \file
  \brief データファイルのリリース処理

  \author Satofumi KAMIMURA

  $Id: ReleaseDataFile.cpp 263 2009-01-30 14:48:10Z satofumi $
*/

#include "ReleaseDataFile.h"
#include "ArchiveConfig.h"
#include "RrdaDecoder.h"
#include "AnimationPattern.h"
#include <cstddef>

using namespace std;


bool releaseDataFile(const ArchiveConfig& archive_config, size_t cell_max)
{
  RrdaDecoder decoder(archive_config.getReleaseName(),
                      archive_config.getRrdaKey());

  const char* tags[] = {
    "config", "base", "digital", "hari_h", "hari_m", "hari_s",
    "days", "separator", "week", "near",
  };

  size_t n = sizeof(tags) / sizeof(tags[0]);

  for (size_t i = 0; i < n; ++i) {

    // 通常データ
    const string normal_value = archive_config.getNormalData(tags[i]);
    if (! normal_value.empty()) {
      decoder.setNormalData(tags[i], normal_value);
    }

    // 制限データ
    const string restrict_value = archive_config.getRestrictData(tags[i]);
    if (! restrict_value.empty()) {
      decoder.setRestrictData(tags[i], restrict_value);
    }
  }

  // アニメーション用の画像データ
  for (size_t i = 0; i < cell_max; ++i) {

    AnimationCellTag cell_tags(i);
    const string value =
      archive_config.getNormalData(cell_tags.simple_tag);
    if (! value.empty()) {
      decoder.setNormalData(cell_tags.simple_tag, value);
    }

  }

  return decoder.release();
}
