#ifndef RELEASE_DATA_H
#define RELEASE_DATA_H

/*!
  \file
  \brief データファイルのリリース処理

  \author Satofumi KAMIMURA

  $Id: ReleaseDataFile.h 263 2009-01-30 14:48:10Z satofumi $
*/

#include <cstddef>

class ArchiveConfig;


/*!
  \brief リリースデータ生成

  \param[in] archive_config アーカイブ管理オブジェクト
  \param[in] cell_max アニメーションのセル枚数

  \retval true 正常
  \retval false エラー
*/
extern bool releaseDataFile(const ArchiveConfig& archive_config,
                            size_t cell_max);

#endif /* !RELEASE_DATA_H */
