#ifndef RELEASE_DIALOG_H
#define RELEASE_DIALOG_H

/*!
  \file
  \brief リリース用ダイアログ

  \author Satofumi KAMIMURA

  $Id: ReleaseDialog.h 261 2009-01-22 06:48:10Z satofumi $
*/

#include "ui_ReleaseDialogForm.h"

class ArchiveConfig;


/*!
  \brief リリースダイアログ管理クラス
*/
class ReleaseDialog : public QDialog, private Ui::ReleaseDialog
{
  Q_OBJECT;

  ReleaseDialog(const ReleaseDialog& rhs);
  ReleaseDialog& operator = (const ReleaseDialog& rhs);

private slots:
  void acceptedHandler(void);

public:

  /*!
    \brief コンストラクタ

    \param[in] parent 親ウィジット
  */
  explicit ReleaseDialog(QDialog* parent = 0);
  ~ReleaseDialog(void);


  /*!
    \brief 初期値の設定

    \param[in] release_file リリースファイル名
    \param[in] rrda_key RRDA キー
  */
  void setDefaultValue(const std::string& release_file,
                       const std::string& rrda_key);

signals:

  /*!
    \brief リリース [signal]

    \param[out] file リリースファイル名
    \param[out] key RRDA キー
  */
  void release(const QString& file, const QString& key);
};

#endif /* !RELEASE_DIALOG_H */
