/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.eclipse.quick;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import junit.extensions.eclipse.quick.NamingRule;
import org.eclipse.jface.preference.IPreferenceStore;

public class NamingRules {
    private IPreferenceStore store;
    private final String STORE_ID = "NamingRules";

    public NamingRules(IPreferenceStore iPreferenceStore) {
        this.store = iPreferenceStore;
    }

    public List get() {
        String string = this.store.getString("NamingRules");
        if (string == null || string.length() == 0) {
            return this.getDefault();
        }
        return this.stringToList(string);
    }

    public String[] getEnableValues() {
        List list = this.get();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            NamingRule namingRule = (NamingRule)list.get(i);
            if (!namingRule.isEnabled()) continue;
            arrayList.add(namingRule.getValue());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void set(List list) {
        this.store.setValue("NamingRules", this.listToString(list));
    }

    private String listToString(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                stringBuffer.append(',');
            }
            NamingRule namingRule = (NamingRule)list.get(i);
            stringBuffer.append(namingRule.getValue() + ":" + namingRule.isEnabled());
        }
        return stringBuffer.toString();
    }

    private List stringToList(String string) {
        ArrayList<NamingRule> arrayList = new ArrayList<NamingRule>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(58);
            if (n == -1) continue;
            String string3 = string2.substring(0, n);
            Boolean bl = Boolean.valueOf(string2.substring(n + 1));
            arrayList.add(new NamingRule(string3, bl));
        }
        return arrayList;
    }

    public List getDefault() {
        ArrayList<NamingRule> arrayList = new ArrayList<NamingRule>();
        arrayList.add(new NamingRule("${package}.${type}Test", true));
        arrayList.add(new NamingRule("${package}.${type}PDETest", false));
        return arrayList;
    }
}

