/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.eclipse.quick;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.internal.commands.Manager;
import org.eclipse.ui.internal.commands.Sequence;
import org.eclipse.ui.internal.commands.Stroke;

public class PopupTableSelector {
    private Shell shell;
    private List items;
    private Object selection;
    private String commandForward;
    private String commandBackward;
    private ILabelProvider labelProvider;
    private String title = "";

    public PopupTableSelector(Shell shell, List list) {
        this.shell = shell;
        this.items = list;
    }

    public void setCommandBackward(String string) {
        this.commandBackward = string;
    }

    public void setCommandForward(String string) {
        this.commandForward = string;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setLabelProvider(ILabelProvider iLabelProvider) {
        this.labelProvider = iLabelProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object select() {
        this.selection = null;
        final Shell shell = new Shell(this.shell, 0);
        Display display = shell.getDisplay();
        shell.setLayout((Layout)new FillLayout());
        Table table = new Table((Composite)shell, 65540);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setResizable(false);
        tableColumn.setText(this.title);
        this.addItems(table, this.items);
        int n = table.getItemCount();
        if (n > 0) {
            table.setSelection(0);
        }
        tableColumn.pack();
        table.pack();
        Rectangle rectangle = table.getBounds();
        rectangle.height = Math.min(rectangle.height, table.getItemHeight() * 22);
        table.setBounds(rectangle);
        shell.pack();
        tableColumn.setWidth(table.getClientArea().width);
        table.setFocus();
        table.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                PopupTableSelector.this.cancel(shell);
            }
        });
        Rectangle rectangle2 = shell.getBounds();
        Rectangle rectangle3 = display.getClientArea();
        Rectangle rectangle4 = shell.getParent().getBounds();
        rectangle2.x = rectangle4.x + (rectangle4.width - rectangle2.width) / 2;
        rectangle2.y = rectangle4.y + (rectangle4.height - rectangle2.height) / 2;
        if (!rectangle3.contains(rectangle2.x, rectangle2.y) || !rectangle3.contains(rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height)) {
            rectangle2.x = (rectangle3.width - rectangle2.width) / 2;
            rectangle2.y = (rectangle3.height - rectangle2.height) / 2;
        }
        rectangle2.height = rectangle2.height + 5 - table.getHorizontalBar().getSize().y;
        shell.setBounds(rectangle2);
        try {
            shell.open();
            this.addMouseListener(table, shell);
            this.addKeyListener(table, shell);
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        finally {
            if (!shell.isDisposed()) {
                this.cancel(shell);
            }
        }
        return this.selection;
    }

    private void addItems(Table table, List list) {
        TableItem tableItem = null;
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            tableItem = new TableItem(table, 0);
            tableItem.setText(this.labelProvider.getText(e));
            tableItem.setData(e);
        }
    }

    private void addMouseListener(final Table table, final Shell shell) {
        table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                PopupTableSelector.this.ok(shell, table);
            }

            public void mouseDown(MouseEvent mouseEvent) {
                PopupTableSelector.this.ok(shell, table);
            }

            public void mouseUp(MouseEvent mouseEvent) {
                PopupTableSelector.this.ok(shell, table);
            }
        });
    }

    private void addKeyListener(final Table table, final Shell shell) {
        table.addKeyListener(new KeyListener(){
            private boolean firstKey = true;
            private boolean quickReleaseMode = false;

            public void keyPressed(KeyEvent keyEvent) {
                int n;
                List list;
                Sequence sequence;
                Iterator iterator;
                Map map;
                SortedSet sortedSet;
                int n2 = keyEvent.keyCode;
                int n3 = keyEvent.stateMask;
                char c = keyEvent.character;
                int n4 = n3 | (n2 != 0 ? n2 : (int)PopupTableSelector.convertCharacter(c));
                boolean bl = false;
                boolean bl2 = false;
                if (PopupTableSelector.this.commandForward != null && (sortedSet = (SortedSet)(map = Manager.getInstance().getKeyMachine().getCommandMap()).get(PopupTableSelector.this.commandForward)) != null) {
                    iterator = sortedSet.iterator();
                    while (iterator.hasNext()) {
                        sequence = (Sequence)iterator.next();
                        list = sequence.getStrokes();
                        n = list.size();
                        if (n <= 0 || n4 != ((Stroke)list.get(n - 1)).getValue()) continue;
                        bl = true;
                        break;
                    }
                }
                if (PopupTableSelector.this.commandBackward != null && (sortedSet = (SortedSet)(map = Manager.getInstance().getKeyMachine().getCommandMap()).get(PopupTableSelector.this.commandBackward)) != null) {
                    iterator = sortedSet.iterator();
                    while (iterator.hasNext()) {
                        sequence = (Sequence)iterator.next();
                        list = sequence.getStrokes();
                        n = list.size();
                        if (n <= 0 || n4 != ((Stroke)list.get(n - 1)).getValue()) continue;
                        bl2 = true;
                        break;
                    }
                }
                if (c == '\r' || c == '\n') {
                    PopupTableSelector.this.ok(shell, table);
                } else if (bl) {
                    if (this.firstKey && keyEvent.stateMask != 0) {
                        this.quickReleaseMode = true;
                    }
                    int n5 = table.getSelectionIndex();
                    table.setSelection((n5 + 1) % table.getItemCount());
                } else if (bl2) {
                    int n6;
                    if (this.firstKey && keyEvent.stateMask != 0) {
                        this.quickReleaseMode = true;
                    }
                    table.setSelection((n6 = table.getSelectionIndex()) >= 1 ? n6 - 1 : table.getItemCount() - 1);
                } else if (n2 != 65536 && n2 != 0x400000 && n2 != 262144 && n2 != 131072 && n2 != 0x1000002 && n2 != 0x1000001 && n2 != 0x1000003 && n2 != 0x1000004) {
                    PopupTableSelector.this.cancel(shell);
                }
                this.firstKey = false;
            }

            public void keyReleased(KeyEvent keyEvent) {
                int n = keyEvent.keyCode;
                int n2 = keyEvent.stateMask;
                if ((this.firstKey || this.quickReleaseMode) && n == n2) {
                    PopupTableSelector.this.ok(shell, table);
                }
            }
        });
    }

    private static char convertCharacter(char c) {
        return c >= '\u0000' && c <= '\u001f' ? (char)(c + 64) : Character.toUpperCase(c);
    }

    private void cancel(Shell shell) {
        this.selection = null;
        shell.close();
    }

    private void ok(Shell shell, Table table) {
        TableItem[] tableItemArray = table.getSelection();
        if (tableItemArray != null && tableItemArray.length == 1) {
            this.selection = tableItemArray[0].getData();
        }
        shell.close();
    }
}

