/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.eclipse.quick;

import junit.extensions.eclipse.quick.Messages;
import junit.extensions.eclipse.quick.QuickJUnitException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class QuickJUnitPlugin
extends AbstractUIPlugin {
    public static final String ID = "junit.extensions.eclipse.quick";
    private static QuickJUnitPlugin plugin;

    public QuickJUnitPlugin(IPluginDescriptor iPluginDescriptor) {
        super(iPluginDescriptor);
        plugin = this;
    }

    public static QuickJUnitPlugin getDefault() {
        return plugin;
    }

    public IStatus createSystemErrorStatus(Exception exception, Object object) {
        int n = 4;
        String string = exception.getMessage();
        if (string == null) {
            string = "";
        }
        MultiStatus multiStatus = new MultiStatus(ID, n, string, (Throwable)exception);
        string = Messages.getString("QuickJUnitPlugin.systemError.providerNameLabel") + this.getDescriptor().getProviderName();
        multiStatus.add(this.createStatus(n, string));
        string = Messages.getString("QuickJUnitPlugin.systemError.pluginNameLabel") + this.getDescriptor().getLabel();
        multiStatus.add(this.createStatus(n, string));
        string = Messages.getString("QuickJUnitPlugin.systemError.pluginIdLabel") + ID;
        multiStatus.add(this.createStatus(n, string));
        String string2 = this.getDescriptor().getVersionIdentifier().toString();
        string = Messages.getString("QuickJUnitPlugin.systemError.versionLabel") + string2;
        multiStatus.add(this.createStatus(n, string));
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        string = Messages.getString("QuickJUnitPlugin.systemError.classLabel") + clazz.getName();
        multiStatus.add(this.createStatus(n, string, 4, exception));
        return multiStatus;
    }

    public IStatus createStatus(int n, String string) {
        return this.createStatus(n, string, 0, null);
    }

    private IStatus createStatus(int n, String string, int n2, Exception exception) {
        return new Status(n, ID, n2, string, (Throwable)exception);
    }

    public void handleSystemError(Exception exception, Object object) {
        IStatus iStatus = this.createSystemErrorStatus(exception, object);
        this.getLog().log(iStatus);
        ErrorDialog.openError((Shell)null, (String)Messages.getString("QuickJUnitPlugin.systemError.dialog.title"), (String)Messages.getString("QuickJUnitPlugin.systemError.dialog.message"), (IStatus)iStatus);
    }

    public void logSystemError(Exception exception, Object object) {
        IStatus iStatus = this.createSystemErrorStatus(exception, object);
        this.getLog().log(iStatus);
    }

    public void logSystemErrorMessage(String string, Object object) {
        IStatus iStatus = this.createSystemErrorStatus((Exception)((Object)new QuickJUnitException(string)), object);
        this.getLog().log(iStatus);
    }
}

