/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.eclipse.quick;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.EditorArea;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorPresentation;
import org.eclipse.ui.internal.EditorWorkbook;
import org.eclipse.ui.internal.ILayoutContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.RootLayoutContainer;
import org.eclipse.ui.internal.WorkbenchPage;

public class EditorSplitter {
    private IWorkbenchPage page;
    private EditorArea area;

    public EditorSplitter(IWorkbenchPage iWorkbenchPage) throws CoreException {
        this.page = iWorkbenchPage;
        this.area = EditorSplitter.getEditorArea(iWorkbenchPage);
    }

    public EditorSplitter(IWorkbenchPart iWorkbenchPart) throws CoreException {
        this(iWorkbenchPart.getSite().getPage());
    }

    private static EditorArea getEditorArea(IWorkbenchPage iWorkbenchPage) throws CoreException {
        if (!(iWorkbenchPage instanceof WorkbenchPage)) {
            throw new WorkbenchException("cannot get WorkbenchPage object.");
        }
        EditorPresentation editorPresentation = ((WorkbenchPage)iWorkbenchPage).getEditorPresentation();
        return (EditorArea)editorPresentation.getLayoutPart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(IFile iFile) throws CoreException {
        IEditorPart iEditorPart = this.page.getActiveEditor();
        EditorPane editorPane = this.getEditorPane(iEditorPart);
        RootLayoutContainer rootLayoutContainer = this.area.getRootContainer();
        boolean bl = rootLayoutContainer.isZoomed();
        IEditorPart iEditorPart2 = this.page.openEditor(iFile, null, false);
        EditorPane editorPane2 = this.getEditorPane(iEditorPart2);
        if (iEditorPart2 == iEditorPart) {
            editorPane2.setFocus();
            editorPane2.showFocus(true);
            return;
        }
        rootLayoutContainer.getControl().setRedraw(false);
        try {
            EditorWorkbook editorWorkbook = null;
            if (editorPane.getWorkbook() == editorPane2.getWorkbook()) {
                this.removeLayoutPart((LayoutPart)editorPane2);
                EditorWorkbook editorWorkbook2 = this.findWorkbook(editorPane.getWorkbook());
                if (editorWorkbook2 == null) {
                    editorWorkbook = editorWorkbook2 = new EditorWorkbook(this.area);
                }
                editorWorkbook2.add((LayoutPart)editorPane2);
            } else if (bl && !editorPane2.isVisible()) {
                editorWorkbook = editorPane2.getWorkbook();
                this.removeLayoutPart((LayoutPart)editorWorkbook);
            }
            if (editorWorkbook != null) {
                this.area.add((LayoutPart)editorWorkbook, 4, 0.5f, (LayoutPart)editorPane.getWorkbook());
            }
            if (bl) {
                rootLayoutContainer.zoomIn((LayoutPart)this.area);
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            rootLayoutContainer.getControl().setRedraw(true);
            editorPane2.setFocus();
            editorPane2.showFocus(true);
            throw throwable;
        }
        rootLayoutContainer.getControl().setRedraw(true);
        editorPane2.setFocus();
        editorPane2.showFocus(true);
    }

    private EditorPane getEditorPane(IEditorPart iEditorPart) {
        ArrayList arrayList = this.area.getEditorWorkbooks();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            EditorWorkbook editorWorkbook = (EditorWorkbook)iterator.next();
            EditorPane[] editorPaneArray = editorWorkbook.getEditors();
            for (int i = 0; i < editorPaneArray.length; ++i) {
                IEditorReference iEditorReference = editorPaneArray[i].getEditorReference();
                if (iEditorReference == null || iEditorPart != iEditorReference.getEditor(false)) continue;
                return editorPaneArray[i];
            }
        }
        return null;
    }

    private void removeLayoutPart(LayoutPart layoutPart) {
        LayoutPart layoutPart2;
        ILayoutContainer iLayoutContainer;
        ILayoutContainer iLayoutContainer2 = layoutPart.getContainer();
        layoutPart.reparent(this.area.getParent());
        if (iLayoutContainer2 == null) {
            return;
        }
        iLayoutContainer2.remove(layoutPart);
        LayoutPart[] layoutPartArray = iLayoutContainer2.getChildren();
        if ((layoutPartArray == null || layoutPartArray.length == 0) && iLayoutContainer2 instanceof LayoutPart && (iLayoutContainer = (layoutPart2 = (LayoutPart)iLayoutContainer2).getContainer()) != null) {
            iLayoutContainer.remove(layoutPart2);
            layoutPart2.dispose();
        }
    }

    private EditorWorkbook findWorkbook(EditorWorkbook editorWorkbook) {
        ArrayList arrayList = this.area.getEditorWorkbooks();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            EditorWorkbook editorWorkbook2 = (EditorWorkbook)iterator.next();
            if (editorWorkbook == editorWorkbook2) continue;
            return editorWorkbook2;
        }
        return null;
    }
}

