/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.eclipse.quick;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class JavaElements {
    public static boolean isTestMethod(IJavaElement iJavaElement) throws JavaModelException {
        if (!(iJavaElement instanceof IMethod)) {
            return false;
        }
        IMethod iMethod = (IMethod)iJavaElement;
        if (iMethod.getNumberOfParameters() != 0) {
            return false;
        }
        if (!iMethod.getReturnType().equals("V")) {
            return false;
        }
        int n = iMethod.getFlags();
        if (!Flags.isPublic((int)n) || Flags.isStatic((int)n)) {
            return false;
        }
        return iMethod.getElementName().startsWith("test");
    }

    public static IType getPrimaryTypeOf(IJavaElement iJavaElement) {
        if (iJavaElement == null) {
            return null;
        }
        ICompilationUnit iCompilationUnit = null;
        if (iJavaElement instanceof ICompilationUnit) {
            iCompilationUnit = (ICompilationUnit)iJavaElement;
        } else if (iJavaElement instanceof IMember) {
            iCompilationUnit = ((IMember)iJavaElement).getCompilationUnit();
        }
        return iCompilationUnit != null ? iCompilationUnit.findPrimaryType() : null;
    }
}

