/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.eclipse.quick;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import junit.extensions.eclipse.quick.Messages;
import junit.extensions.eclipse.quick.NamingRule;
import junit.extensions.eclipse.quick.QuickJUnitPreferencePage;
import org.eclipse.jdt.internal.junit.util.SWTUtil;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class NamingRulesPreference {
    private QuickJUnitPreferencePage preferencePage;
    private Shell shell;
    private List namingRulesValue;
    private CheckboxTableViewer tableViewer;
    private Button addButton;
    private Button removeButton;
    private Button editButton;
    private Button moveUpButton;
    private Button moveDownButton;

    public NamingRulesPreference(QuickJUnitPreferencePage quickJUnitPreferencePage) {
        this.preferencePage = quickJUnitPreferencePage;
    }

    public void create(List list, Composite composite) {
        this.namingRulesValue = list;
        this.shell = composite.getShell();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        this.createTable(composite2);
        this.createButtons(composite2);
        this.update();
    }

    public void setValue(List list) {
        this.namingRulesValue = list;
        this.update();
    }

    public List getValue() {
        return this.namingRulesValue;
    }

    private void createTable(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("NamingRulesPreference.label"));
        GridData gridData = new GridData(32);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        Table table = new Table(composite, 67618);
        gridData = new GridData(768);
        table.setLayoutData((Object)gridData);
        TableLayout tableLayout = new TableLayout();
        ColumnLayoutData[] columnLayoutDataArray = new ColumnLayoutData[]{new ColumnWeightData(100)};
        tableLayout.addColumnData(columnLayoutDataArray[0]);
        table.setLayout((Layout)tableLayout);
        new TableColumn(table, 0);
        this.tableViewer = new CheckboxTableViewer(table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setInput((Object)this);
        gridData = new GridData(1808);
        this.tableViewer.getTable().setLayoutData((Object)gridData);
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                NamingRule namingRule = (NamingRule)checkStateChangedEvent.getElement();
                namingRule.setEnabled(checkStateChangedEvent.getChecked());
                NamingRulesPreference.this.update();
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                NamingRulesPreference.this.updateButtons();
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                NamingRulesPreference.this.editNamingRule();
            }
        });
    }

    private void createButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData(1040);
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        Object object = new Listener(){

            public void handleEvent(Event event) {
                NamingRulesPreference.this.addNamingRule();
            }
        };
        this.addButton = this.createButton("addButton", composite2, (Listener)object, true);
        object = new Listener(){

            public void handleEvent(Event event) {
                NamingRulesPreference.this.removeNamingRules();
            }
        };
        this.removeButton = this.createButton("removeButton", composite2, (Listener)object, false);
        this.removeButton.setEnabled(false);
        object = new Listener(){

            public void handleEvent(Event event) {
                NamingRulesPreference.this.editNamingRule();
            }
        };
        this.editButton = this.createButton("editButton", composite2, (Listener)object, false);
        this.editButton.setEnabled(false);
        object = new Listener(){

            public void handleEvent(Event event) {
                NamingRulesPreference.this.moveNamingRule(true);
            }
        };
        this.moveUpButton = this.createButton("moveUpButton", composite2, (Listener)object, false);
        this.moveUpButton.setEnabled(false);
        object = new Listener(){

            public void handleEvent(Event event) {
                NamingRulesPreference.this.moveNamingRule(false);
            }
        };
        this.moveDownButton = this.createButton("moveDownButton", composite2, (Listener)object, false);
        this.moveDownButton.setEnabled(false);
    }

    private void update() {
        this.tableViewer.refresh();
        for (int i = 0; i < this.namingRulesValue.size(); ++i) {
            NamingRule namingRule = (NamingRule)this.namingRulesValue.get(i);
            this.tableViewer.setChecked((Object)namingRule, namingRule.isEnabled());
        }
        this.updateButtons();
    }

    private void updateButtons() {
        boolean bl;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.tableViewer.getSelection();
        this.removeButton.setEnabled(!iStructuredSelection.isEmpty());
        this.editButton.setEnabled(iStructuredSelection.size() == 1);
        int n = this.tableViewer.getTable().getItemCount();
        boolean bl2 = bl = iStructuredSelection.size() == 1 && n > 1;
        if (!bl) {
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
        } else {
            int n2 = this.namingRulesValue.indexOf(iStructuredSelection.getFirstElement());
            this.moveUpButton.setEnabled(0 < n2);
            this.moveDownButton.setEnabled(n2 < n - 1);
        }
    }

    private void editNamingRule() {
        String string;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.tableViewer.getSelection();
        if (iStructuredSelection.isEmpty()) {
            return;
        }
        NamingRule namingRule = (NamingRule)iStructuredSelection.getFirstElement();
        InputDialog inputDialog = this.createEditDialog("editNamingRule", namingRule.getValue());
        if (inputDialog.open() == 0 && (string = inputDialog.getValue()).trim().length() != 0) {
            namingRule.setValue(string);
            this.update();
        }
    }

    private InputDialog createEditDialog(String string, String string2) {
        String string3 = Messages.getString("NamingRulesPreference." + string + ".dialog.title");
        String string4 = Messages.getString("NamingRulesPreference." + string + ".dialog.message");
        return new InputDialog(this.shell, string3, string4, string2, (IInputValidator)new NamingRuleValidator());
    }

    private void addNamingRule() {
        String string;
        InputDialog inputDialog = this.createEditDialog("addNamingRule", "");
        if (inputDialog.open() == 0 && (string = inputDialog.getValue()).trim().length() != 0) {
            NamingRule namingRule = new NamingRule(string, true);
            this.namingRulesValue.add(namingRule);
            this.update();
        }
    }

    private void removeNamingRules() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.tableViewer.getSelection();
        if (iStructuredSelection.isEmpty()) {
            return;
        }
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            this.namingRulesValue.remove(iterator.next());
        }
        this.update();
    }

    private void moveNamingRule(boolean bl) {
        int n;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.tableViewer.getSelection();
        if (iStructuredSelection.isEmpty() || iStructuredSelection.size() > 1) {
            return;
        }
        Object object = iStructuredSelection.getFirstElement();
        int n2 = this.namingRulesValue.indexOf(object);
        int n3 = n = bl ? n2 - 1 : n2 + 1;
        if (n < 0 || this.namingRulesValue.size() <= n) {
            return;
        }
        this.namingRulesValue.remove(n2);
        this.namingRulesValue.add(n, object);
        this.update();
    }

    private Button createButton(String string, Composite composite, Listener listener, boolean bl) {
        Button button = new Button(composite, 8);
        button.setText(Messages.getString("NamingRulesPreference." + string + ".label"));
        button.setToolTipText(Messages.getString("NamingRulesPreference." + string + ".tooltip"));
        GridData gridData = bl ? new GridData(770) : this.preferencePage.getButtonGridData(button);
        button.setLayoutData((Object)gridData);
        SWTUtil.setButtonDimensionHint((Button)button);
        button.addListener(13, listener);
        return button;
    }

    private static class NamingRuleValidator
    implements IInputValidator {
        private NamingRuleValidator() {
        }

        public String isValid(String string) {
            if ((string = string.trim()).length() == 0) {
                return Messages.getString("NamingRulesPreference.namingRuleValidator.empty");
            }
            string = string.replaceAll("\\$\\{package\\}", "package");
            string = string.replaceAll("\\$\\{type\\}", "type");
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (bl) {
                    if (!string2.equals(".")) {
                        return Messages.getString("NamingRulesPreference.namingRuleValidator.error");
                    }
                    bl = false;
                    continue;
                }
                if (!this.isJavaIdentifier(string2)) {
                    return Messages.getString("NamingRulesPreference.namingRuleValidator.tokenError", string2);
                }
                bl = true;
            }
            return null;
        }

        private boolean isJavaIdentifier(String string) {
            if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                return false;
            }
            for (int i = 1; i < string.length(); ++i) {
                if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
                return false;
            }
            return true;
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public Object[] getElements(Object object) {
            return NamingRulesPreference.this.namingRulesValue.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private static class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public String getColumnText(Object object, int n) {
            return n == 0 ? ((NamingRule)object).getValue() : "";
        }

        public String getText(Object object) {
            return ((NamingRule)object).getValue();
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }
    }
}

