<?php
/**
 *	Project:	aiueo_sort
 *	File:		aiueo_sort.class.php
 *
 *	@copyright	Tomoyuki Negishi and ZubaPitaTech, Inc.
 *	@author		Tomoyuki Negishi <tomoyu-n@zubapita.jp>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	aiueo_sort
 *	@version	$Id: aiueo_sort.class.php,v 1.1.1.1 2006/07/23 20:50:29 tomoyu-n Exp $
 */

// {{{ aiueo_sort_lib
/**
 *	aiueo_sort_lib class
 *
 *	@author		Tomoyuki Negishi <tomoyu-n@zubapita.jp>
 *	@access		public
 *	@package	aiueo_sort
 */
class aiueo_sort_lib {

 /**
 * A temporary array to aiueo sort.
 *
 * @var     array
 * @access  private
 */
var $array = array();

 /**
 * A table of each characters weight value of aiueo.
 *
 * @var     array
 * @access  private
 */
var $aiueo_table = array(
	''=>1,''=>2,''=>3,''=>4,''=>5,
	''=>1,''=>2,''=>3,''=>4,''=>5,
	''=>6,''=>7,''=>8,''=>9,''=>10,
	''=>6,''=>7,''=>8,''=>9,''=>10,
	''=>11,''=>12,''=>13,''=>14,''=>15,
	''=>11,''=>12,''=>13,''=>14,''=>15,
	''=>16,''=>17,''=>18,''=>19,''=>20,
	''=>16,''=>17,''=>18,''=>19,''=>20,
	''=>21,''=>22,''=>23,''=>24,''=>25,
	''=>26,''=>27,''=>28,''=>29,''=>30,
	''=>26,''=>27,''=>28,''=>29,''=>30,
	''=>26,''=>27,''=>28,''=>29,''=>30,
	''=>31,''=>32,''=>33,''=>34,''=>35,
	''=>36,''=>38,''=>40,
	''=>36,''=>38,''=>40,
	''=>41,''=>42,''=>43,''=>44,''=>45,
	''=>46,''=>50,''=>51,''=>52,
	''=>46
);

/**
 *	Compare two strings order by aiueo with $this->aiueo_table.
 *	A voiceless sound ('Sei_on' in Japanese) and a voiced consonant ('Daku_on' in Japanese)
 *	have same weight in this routine.
 *
 *	@access	private
 *	@param	string $a_string
 *	@param	string $b_string
 *	@return	integer $a_string > $b_string : 1
 *                  $a_string < $b_string : -1
 *                  $a_string == $b_string : 0
 */
function aiueo_compare($a_string, $b_string) {
	while($a_string) {
		$a_char = mb_substr($a_string,0,1);
		$a_string = mb_substr($a_string,1);
		$b_char = mb_substr($b_string,0,1);
		$b_string = mb_substr($b_string,1);
		if($this->aiueo_table[$a_char] > $this->aiueo_table[$b_char]) 
			return 1;
		if($this->aiueo_table[$a_char] < $this->aiueo_table[$b_char]) 
			return -1;
		if($a_string and !$b_string) 
			return 1;
		if($b_string and !$a_string) 
			return 1;
	}
	return 0;
}

/**
 *	Sort temporary array '$this->array' order by aiueo with 'quick sort' method.
 *
 *	@access	private
 *	@param	integer $L   Left pointer position of array
 *	@param	interger $R  Right pointer position of array
 *	@return	void
 */
function aiueo_quick_sort($L,$R) {
	$X = $this->array[($L+$R) / 2];
	$I = $L -1;
	$J = $R + 1;
	do {
		do {$I++;} while($this->aiueo_compare($X, $this->array[$I])==1);
		do {$J--;} while($this->aiueo_compare($this->array[$J],$X)==1);
		$T = $this->array[$I];
		$this->array[$I] = $this->array[$J];
		$this->array[$J] = $T;
	} while($I < $J);
	$this->array[$J] = $this->array[$I];
	$this->array[$I] = $T;
	if($L < $I-1) $this->aiueo_quick_sort($L,$I-1);
	if($J+1 < $R) $this->aiueo_quick_sort($J+1,$R);
}

/**
 *	Sort array '$array' order by aiueo.
 *
 *	@access	public
 *	@param	array $array   array of Japanese aiueo string
 *	@return	boolean status success : true
 *                         false : false
 */
function aiueo_sort(&$array) {
	if(is_array($array) and count($array)>1) {
		$this->array =& $array;
		$this->aiueo_quick_sort(1,count($this->array));
		unset($this->array);
		return true;
	} else {
		return false;
	}
}

/**
 *	Sort array '$array'  by key order by aiueo.
 *
 *	@access	public
 *	@param	array $array   array of Japanese aiueo string
 *	@return	boolean status success : true
 *                         false : false
 */
function aiueo_ksort(&$array) {
	if(is_array($array) and count($array)>1) {
		$this->array = array_keys($array);
		$this->aiueo_quick_sort(0,count($this->array)-1);
		$t_array = $array;
		$array = array();
		foreach($this->array as $key) {
			$array[$key] = $t_array[$key];
		}
		unset($this->array);
		return true;
	} else {
		return false;
	}
}


}
// end of aiueo_sort_lib
// }}}
