<?php

require_once 'Quicty/phplib/GoogleMapAPI.class.php';

/**
 * Google Map API 饹б뤿γĥ饹
 */
class GoogleMapAPI_jp extends GoogleMapAPI {

    /**
     * 󥹥ȥ饯
     *
     * @param string $map_id ϿID
     * @param string $app_id YahooɤȤ硢Yahoo App ID
     */
    function GoogleMapAPI_jp($map_id = 'map', $app_id = 'MyMapApp') {
        parent::GoogleMapAPI($map_id, $app_id);
        // ܤǤƻϵǽʤΤǾ˥դˤ
        $this->disableDirections();
    }

    /**
     * ܸɥӥɲ
     *
     * @param service GEOCODING_JP  geocoding.jp ΥӥѤ
     */
    function setLookupService($service) {
        switch($service) {
            case 'GEOCODING_JP':    // http://geocoding.jp/
                $this->lookup_service = 'GEOCODING_JP';
                break;
            case 'GOOGLE_JP':    // http://geocoding.jp/
                $this->lookup_service = 'GOOGLE_JP';
                break;
            case 'GOOGLE':
            case 'YAHOO':
            default:
                return parent::setLookupService($service);
        }
    }

    /**
     * ꤫ɸ
     *   ܤΥǥ󥰥ӥɲä
     *
     * @param string $address 
     * @return mixed Ĥкɸ󡢸Ĥʤ false
     */
    function geoGetCoords($address) {
        switch($this->lookup_service) {
            case 'GOOGLE_JP':
                $url = 'http://maps.google.co.jp/maps/geo';
                $encoded_address = mb_convert_encoding($address,'UTF-8','EUC-JP');
                $params = array(
                                 'key'=>$this->api_key,
                                 'q'=>$encoded_address,
                                 'output'=>'xml',
                                 'ie'=>'UTF8'
                                );
                $query = http_build_query($params);
                $gottenXml = $this->fetchURL($url.'?'.$query);
                $is_matched = preg_match(
                    '!<coordinates>([0-9.]*?),([0-9.]*?),0</coordinates>!U',
                    $gottenXml, $_match
                );
                $_coords = false;
                if ($is_matched) {
                    $_coords['lon'] = $_match[1];
                    $_coords['lat'] = $_match[2];
                }
                break;

            case 'GEOCODING_JP':
                $url = 'http://www.geocoding.jp/api/';
                $url .= sprintf('?q=%s',rawurlencode($address));

                $gottenXml = $this->fetchURL($url);
                if(!$gottenXml) {
                    return false;
                }
                $is_matched = preg_match(
                    '!<lat>([0-9.]*)</lat>[\n\r]*<lng>([0-9.]*)</lng>!U',
                    $gottenXml, $_match
                );
                $_coords = false;
                if ($is_matched) {
                    $_coords['lon'] = $_match[2];
                    $_coords['lat'] = $_match[1];
                }
                break;

            // ------------ original code copied from parent class -------
            case 'GOOGLE':
            case 'YAHOO':
            default:
                return parent::geoGetCoords($address);
        }
        return $_coords;
    }

}

?>
