<?php
class reviews_list_options extends myQuicty {

function __construct($page) {
	parent::__construct();
	$this->page = $page;
	$this->list = $this->page->list;
}

var $perPage = 20;

function get_pager_option($add_condition='') {
	$where_condition = $this->make_where_condition($add_condition);
	$join_condition = $this->make_join_condition();
	$select_condition = $join_condition.' '.$where_condition;
	$pager_option = $this->set_pager_option($this->perPage,$select_condition);
	return $pager_option;
}

function make_where_condition($add_condition='') {
	$search_system_file = $this->page->home_dir.'/etc/search_view/reviews.sys';
	if(file_exists($search_system_file)) {
		$search_system = read_data_array($search_system_file);
	} else {
		$search_system = array(
			'keyword'=>array('title'=>'reviews.name','url'=>'reviews.url'), // keyword search target column
			'condition'=>array('id'=>'reviews.id','application_id'=>'reviews.application_id'), // id search target column
			//'period'=>array('start_date'=>array('column'=>'date','end'=>'end_date'))
			);
	}
	return $this->list->make_condition($search_system,$add_condition);
}

function make_join_condition() {
	$this->list->real_count = true; // set this flag if join other table
	$join_condition = "left join items on reviews.items_id=items.id".
					" left join userauth on reviews.user_id=userauth.id";
	return $join_condition;
}

function make_select_fields() {
	$select_system = array(
		//'reviews'=>'*', // specify all column
		//'reviews'=>array('id','name','url'), // specify each column
		'reviews'=>array('id'=>'id','comment'=>'comment','rate'=>'rate','items_id'=>'items_id','user_id'=>'user_id','update_datetime'=>'update_datetime'),
		'userauth'=>array('handle'=>'handle'),
		'items'=>array('name'=>'items_name'), //specify another column name
		);
	return $this->list->make_select_fields($select_system);
}

function make_sort_condition() {
	$sort_system = array(
		'default'=>' order by reviews.id',
		// sort keys
		//'columns'=>'*', // specify all column
		//'columns'=>array('id','name','url'), // specify each column
		'columns'=>array('id'=>'reviews.id','items_id'=>'items.name','update_datetime'=>'reviews.update_datetime'),
		);
	return $this->list->make_order($sort_system);
}

} // end of class reviews_list_options
?>