<?php
//require_once 'Quicty/phplib/GoogleMapAPI.class.php';
require_once 'Quicty/phplib/GoogleMapAPI.class_jp.php';

class GoogleMap {

function GoogleMap($dsn,$API_key,$width,$height,$zoom=0) {
	$this->map = new GoogleMapAPI_jp();
	if($dsn) $this->map->setDSN($dsn);
	$this->map->setAPIKey($API_key);
	$this->map->setWidth($width);
	$this->map->setHeight($height);
	$this->map->enableMapControls();
	if($zoom==0) {
		$this->map->enableZoomEncompass();
	} else {
		$this->map->setZoomLevel($zoom);
		$this->map->disableZoomEncompass();
	}
	
	$this->map->setBrowserAlert(
		'ȤΥ֥饦ǤϿޤɽ뤳ȤǤޤ'
		.'Internet Explorer 6.0ʹߤ'
		.'Firefox 1.0ʹߤ򤪤ᤷޤ');
	$this->map->setJSAlert('ȤΥ֥饦ǤJavascript'
		.'бƤʤJavascript դˤʤäƤޤ'
		.'Javascript ư֥饦ǤʤϿޤɽǤޤ');

	$this->map->setInfoWindowTrigger('mouseclick');
	$this->map->setLookupService('GOOGLE_JP');

} // end of constructer

function enable_sidebar() {
	return $this->map->enableSidebar();
}

function disable_sidebar() {
	return $this->map->disableSidebar();
}

function add_marker_by_address($address,$name,$html='') {
	return $this->map->addMarkerByAddress(
				$address,
				$name,
				$html
			);
}

function add_marker_by_geocode($geocode,$name,$html='') {
	return $this->map->addMarkerByCoords(
				$geocode['lon'],
				$geocode['lat'],
				$name,
				$html
			);
}

function set_center($geocode) {
	return $this->map->setCenterCoords($geocode['lon'],$geocode['lat']);
}

function adjust_center($geocode) {
	return $this->map->adjustCenterCoords($geocode['lon'],$geocode['lat']);
}

function get_components() {
	$this->components['headerJS'] = $this->map->getHeaderJS();
	$this->components['mapJS'] = $this->map->getMapJS();
	$this->components['mapBody'] = $this->map->getMap();
	$this->components['mapSidebar'] = $this->map->getSidebar();
	return $this->components;
}

function get_geocode($address,$get_from_service=false) {
	if($get_from_service) {
		$geocode = $this->map->geoGetCoords($address);
	} else {
		$geocode = $this->map->getGeocode($address);
	}
	return $geocode;
}

function get_distance($geocode1,$geocode2,$unit='K') {
	return $this->map->geoGetDistance(
				$geocode1['lat'],
				$geocode1['lon'],
				$geocode2['lat'],
				$geocode2['lon'],
				$unit
			);
}


/*

ٷɽѴ桼ƥƥ

DMS(Degrees Minutes Seconds)١ʬ' " 
٤degree(360١ˡʬ60ʬä60äǷ夬롣äϾɽ
13540'19.31" 13943'55.52"
2E139.44.13.911N35.40.23.315		MAPFANϡ
335/40/23.315,139/44/13.911		ʥץϡ

DD(decimal degree)(10ɽ)
ٰʲ򾮿ɽ
35.672031,139.732089				GoogleMapϡ

msec(mili seconds)ߥ
ߥñ̤ɽ


Ѵˡ
(1)
[DDξʲ] = [ʬ] / 60 + [] / 3600
(2)
msec = (١ʬ/60/60) * 3600 * 1000
*/

function tr_dms_to_dd($dms) {
	list($degree,$minites,$seconds,$otoseconds) = explode('.',$dms);
	$seconds = $seconds + $otoseconds/10.0;
	$msec = $minites/60.0 + $seconds/3600.0;
	$dd = (float) $degree + (float) $msec;
	return $dd;
}

function tr_geocode_dms_to_dd($geocode) {
	$geocode['lat'] = $this->tr_dms_to_dd($geocode['lat']);
	$geocode['lon'] = $this->tr_dms_to_dd($geocode['lon']);
	return $geocode;
}

function tr_dms_to_msec($dms) {
	list($degree,$minites,$seconds,$otoseconds) = explode('.',$dms);
	$seconds = $seconds + $otoseconds/10.0;
	//$msec = ($degree + $minites/60.0 + $seconds/3600.0) * 3600000.0;
	$msec = (int) floor(($degree + $minites/60.0 + $seconds/3600.0) * 36000.0);
	return $msec;
}

function tr_geocode_dms_to_msec($geocode) {
	$geocode['lat'] = $this->tr_dms_to_msec($geocode['lat']);
	$geocode['lon'] = $this->tr_dms_to_msec($geocode['lon']);
	return $geocode;
}

function tr_dd_to_msec($dd) {
	$msec = (int) floor($dd *  3600000.0);
	//$msec = (int) floor($dd *  36000.0);
	return $msec;
}

function tr_geocode_dd_to_msec($geocode) {
	$geocode['lat'] = $this->tr_dd_to_msec($geocode['lat']);
	$geocode['lon'] = $this->tr_dd_to_msec($geocode['lon']);
	return $geocode;
}

function tr_msec_to_dd($msec) {
	$dd = $msec /  3600000.0;
	//$dd = $msec /  36000.0;
	return $dd;
}

function tr_geocode_msec_to_dd($geocode) {
	$geocode['lat'] = $this->tr_msec_to_dd($geocode['lat']);
	$geocode['lon'] = $this->tr_msec_to_dd($geocode['lon']);
	return $geocode;
}


/*
ѴؿȤʤ¬ϷϤѴ

BȷLοͤϡñ(D)

TokyoWGS84

B:WGS84 = B:Tokyo - 0.00010695*B:Tokyo + 0.000017464*L:Tokyo + 0.0046017
L:WGS84 = L:Tokyo - 0.000046038*B:Tokyo - 0.000083043*L:Tokyo + 0.010040

WGS84Tokyo

B:Tokyo = B:WGS84 + 0.00010696*B:WGS84 - 0.000017467*L:WGS84 - 0.0046020
L:Tokyo = L:WGS84 + 0.000046047*B:WGS84 + 0.000083049*L:WGS84 - 0.010041

Max0.1á5mٰ㤦Ф롣

*/

function tr_geocode_tokyo_to_wgs84($tokyo) {
	$wgs['lat'] = $tokyo['lat'] + 0.00010695*$tokyo['lat'] - 0.000017464*$tokyo['lon'] - 0.0046017;
	$wgs['lon'] = $tokyo['lon'] + 0.000046038*$tokyo['lat'] - 0.000083043*$tokyo['lon'] - 0.010040;
	return $tokyo;
}



function tr_geocode_wgs84_to_tokyo($wgs) {
	$tokyo['lat'] = $wgs['lat'] + (0.00010696*$wgs['lat']) - (0.000017467*$wgs['lon']) - 0.0046020;
	$tokyo['lon'] = $wgs['lon'] + (0.000046047*$wgs['lat']) - (0.000083049*$wgs['lon']) - 0.010041;
	return $tokyo;
}




} // end of class GoogleMap



class GoogleMapAPI_jp extends GoogleMapAPI {

function GoogleMapAPI_jp($map_id = 'map', $app_id = 'MyMapApp') {
	parent::GoogleMapAPI($map_id, $app_id);
	$this->disableDirections();
}

function setLookupService($service) {
	switch($service) {
		case 'GOOGLE_JP':
			$this->lookup_service = 'GOOGLE_JP';
			break;
		case 'GOOGLE':
		case 'YAHOO':
		default:
			return parent::setLookupService($service);
	}
}

function geoGetCoords($address) {
	switch($this->lookup_service) {
		case 'GOOGLE_JP':
			$url = 'http://maps.google.co.jp/maps/geo';
			$encoded_address = mb_convert_encoding($address,'UTF-8','EUC-JP');
			$params = array(
							'key'=>$this->api_key,
							'q'=>$encoded_address,
							'output'=>'xml',
							'ie'=>'UTF8'
							);
			$query = http_build_query($params);
			//$gottenXml = $this->fetchURL($url.'?'.$query);
			$gottenXml = file_get_contents($url.'?'.$query);
			$is_matched = preg_match(
				'!<coordinates>([0-9.]*?),([0-9.]*?),0</coordinates>!U',
				$gottenXml, $_match
			);
			$_coords = false;
			if ($is_matched) {
				$_coords['lon'] = $_match[1];
				$_coords['lat'] = $_match[2];
			}
			break;
		case 'GOOGLE':
		case 'YAHOO':
		default:
			return parent::geoGetCoords($address);
	}
	return $_coords;
}

} // end of class GoogleMapAPI_jp

?>
