<?php
class items_base extends myQuicty {


function pre_dispatch_index() {
	parent::pre_dispatch_index();
	$this->caching = 0; // caching page flag: 0 = none; 1 = simple; 2 = each query
	$this->cache_lifetime = 1800; // cache life time by seconds
	$this->cache_id = get_query_id();
	$this->page['base_url'] = quicty_base_url();
	$this->page['data_name'] = 'items';

	if(!$this->user['id'] and in_array($this->dispatch_action,array(1=>'add','edit','delete'))) {
		$query = http_build_query($_GET);
		redirect('<!--{$folder_name}-->/items/error?'.$query);
	}
	return true;
}

function assign_search_form($page_obj=NULL) {
	if($page_obj) {
		$my = $page_obj;
	} else {
		$my = $this;
	}
	$search_form = $my->new_search_obj('items_search',array('action'=>$my->page['base_url'].'<!--{$folder_name}-->/items/','method'=>'get'));
	$my->assign_form('search_form',$search_form);
}

function list_records($condition='') {
	require_once 'list_options.class.php';
	$this->list = $this->new_data_set('items');
	$options = new items_list_options($this);
	$pager_option = $options->get_pager_option($condition);
	$this->list->bind_pager($pager_option);
	
	$fields = $options->make_select_fields();
	$sort_condition = $options->make_sort_condition();
	$list_table = $this->list->select_table_with_pager($sort_condition,$fields);
	return $list_table;
}


function display_record($condition='') {
	require_once 'form_options.class.php';
	$this->form = $this->new_data_set('items');
	$options = new items_form_options($this);
	$options->set_form_options();
	$this->form->validate_and_freeze();
	$this->form->bind_button_control();
	
	$result = $this->form->automatic_form_handler($condition);
	$this->items = $result['items'] ? $result['items'] : $result['values'];
	return $result;
}


function assign_page_and_pathlist() {
	$upper_path = 'ڡ';
	$this->add_pathlist('<!--{$folder_name}-->/items/',$upper_path,false);
	$this->add_pathlist('',$this->page['name']);
	$this->assign('page',$this->page);
}

} // end of items_base class
?>