<?php
require_once "Quicty/phplib/HTTP/Request.php";
require_once 'Quicty/lib/HtmlParser.class.php';

class Atom {

var $user_id;
var $password;
var $atom_xml_url;
var $atom_entry_point;

public function Atom($user_id,$password,$blog_url) {
	$this->user_id = $user_id;
	$this->password = $password;
	$html = file_get_contents($blog_url);
	$tag_tree = new HtmlParser($html);
	$link_tag = $tag_tree->get_head_element_by_type('link','application/atom+xml');
	$this->atom_xml_url = $link_tag['attributes']['href'];
	$xml = file_get_contents($this->atom_xml_url);
	$this->atom_entry_point = $this->get_uri($xml,'service.post');
	//echo "atom_entry_point=".$this->atom_entry_point."\n";
}

function get_uri($xml,$kind) {
	$root = simplexml_load_string($xml);
	foreach($root->link as $link) {
		$rel = $link->attributes()->rel;
		if($rel==$kind) {
			$uri = $link->attributes()->href;
			break;
		}
	}
	return $uri;
}


function get_wsse() {
	$created = date('Y-m-d\TH:i:s\Z');
	$nonce = pack('H*', sha1(md5(time())));
	$pass_digest = base64_encode(pack('H*', sha1($nonce.$created.$this->password))); 
	$wsse = 
'UsernameToken Username="'.$this->user_id.'", PasswordDigest="'.$pass_digest.'", Nonce="'.base64_encode($nonce).'",Created="'.$created.'"';
	return $wsse;
}

function get_request($url,$wsse) {
	$request = new HTTP_Request();
	$request->setURL($url);
	$request->addHeader('X-WSSE',$wsse );
	$request->addHeader('Content-Type', 'application/x.atom+xml');
	$request->addHeader('Cache-Control', 'no-cache');
	$request->setMethod(HTTP_REQUEST_METHOD_GET);
	$response = $request->sendRequest();
	if (PEAR::isError($response)) {
		return $response;
	}
	$response_body = $request->getResponseBody();
	return $response_body;
}

public function get_info() {
	$wsse = $this->get_wsse();
	$response_body = $this->get_request($this->atom_entry_point,$wsse);
	return $response_body;
}


function post_request($url,$wsse,$request_body,$method=HTTP_REQUEST_METHOD_POST) {
	$request = new HTTP_Request();
	$request->setURL($url);
	$request->addHeader('X-WSSE',$wsse );
	$request->addHeader('Content-Type', 'application/x.atom+xml');
	$request->addHeader('Cache-Control', 'no-cache');
	$request->setMethod($method);
	if($request_body) $request->addRawPostData($request_body);
	$response = $request->sendRequest();
	if (PEAR::isError($response)) {
		return $response;
	}
	$response_body = $request->getResponseBody();
	return $response_body;
}


public function post_entry($title,$category,$body) {
	$encoding = mb_internal_encoding();
	$title = mb_convert_encoding($title,'UTF-8',$encoding);
	$category = mb_convert_encoding($category,'UTF-8',$encoding);
	$body = mb_convert_encoding($body,'UTF-8',$encoding);
	$body = base64_encode($body);
	$wsse = $this->get_wsse();
	$request_body = <<<END_OF_XML
<?xml version="1.0"?>
<entry xmlns="http://purl.org/atom/ns#" xmlns:dc="http://purl.org/dc/elements/1.1/">
	<title type="text/html" mode="escaped">$title</title>
	<dc:subject type="text/html" mode="escaped">$category</dc:subject>
	<content type="application/xhtml+xml" mode="base64">$body</content>
</entry>
END_OF_XML;
	$response_body = $this->post_request($this->atom_entry_point,$wsse,$request_body);
	return $response_body;
}

public function update_entry($edit_uri,$title,$category,$body) {
	$encoding = mb_internal_encoding();
	$title = mb_convert_encoding($title,'UTF-8',$encoding);
	$category = mb_convert_encoding($category,'UTF-8',$encoding);
	$wsse = $this->get_wsse();
	$body = mb_convert_encoding($body,'UTF-8',$encoding);
	$body = base64_encode($body);
	$request_body = <<<END_OF_XML
<?xml version="1.0"?>
<entry xmlns="http://purl.org/atom/ns#" xmlns:dc="http://purl.org/dc/elements/1.1/">
	<title type="text/html" mode="escaped">$title</title>
	<dc:subject type="text/html" mode="escaped">$category</dc:subject>
	<content type="application/xhtml+xml" mode="base64">$body</content>
</entry>
END_OF_XML;
	$response_body = $this->post_request($edit_uri,$wsse,$request_body,HTTP_REQUEST_METHOD_PUT);
	return $response_body;
}

public function delete_entry($edit_uri) {
	$wsse = $this->get_wsse();
	$response_body = $this->post_request($edit_uri,$wsse,$request_body='',HTTP_REQUEST_METHOD_DELETE);
	return $response_body;
}

} // end of class Atom

?>