<?php
require_once 'Quicty/phplib/Image/Graph.php'; 
require_once 'Quicty/phplib/Image/Canvas.php'; 

class Graph {

public function Graph($param) {
	$width = $param['width'] ? $param['width'] : 400;
	$height = $param['height'] ? $param['height'] : 300;
	$title = $param['title'] ? $param['title'] : '';
	$titleSize = $param['titleSize'] ? $param['titleSize'] : 10;
	$fontSize = $param['fontSize'] ? $param['fontSize'] : 7;

	$this->Canvas = Image_Canvas::factory('png', array('width' => $width, 'height' => $height, 'antialias' => true));
	$this->Graph = Image_Graph::factory('graph', $this->Canvas); 
	$this->Font = $this->Graph->addNew('font', 'Mincho');
	$this->Font->setSize($fontSize);
	$this->Graph->setFont($this->Font);
	$title = mb_convert_encoding($title,'UTF-8','EUC-JP');
	if($param['legend']) {
		$this->Graph->add( 
			Image_Graph::vertical(
				Image_Graph::factory('title', array($title,$titleSize)),
				Image_Graph::vertical(
					$this->Plotarea = Image_Graph::factory('plotarea'), 
					$this->Legend = Image_Graph::factory('legend'),
					88
				),
				14
			)
		);
		$this->Legend->setPlotarea($this->Plotarea);
		$this->Legend->setPadding(0);
	} else {
		$this->Graph->add( 
			Image_Graph::vertical(
				Image_Graph::factory('title', array($title,$titleSize)),
				$this->Plotarea = Image_Graph::factory('plotarea'), 
				14
			)
		);
	}
	$this->Axis = Image_Graph::factory('axis');
	$this->Plotarea->setPadding(array("top"=>1,"right"=>2,"bottom"=>2,"left"=>2));
	$this->AxisX = $this->Plotarea->getAxis('x');
	$this->AxisY = $this->Plotarea->getAxis('y');
}

function set_background($background_color='gray@0.05') {
	$this->Plotarea->setFillColor($background_color);
}

function set_x_grid($line_color='gray@0.1') {
	$this->x_grid = $this->Plotarea->addNew('line_grid', null, IMAGE_GRAPH_AXIS_X);
	$this->x_grid->setLineColor($line_color);
}

function set_y_grid($line_color='gray@0.1') {
	$this->y_grid = $this->Plotarea->addNew('line_grid', null, IMAGE_GRAPH_AXIS_Y);
	$this->y_grid->setLineColor($line_color);
}

function set_x_label_interbal($label_interval) {
	$this->AxisX->setLabelInterval($label_interval);
}

function set_y_label_interbal($label_interval) {
	$this->AxisY->setLabelInterval($label_interval);
}

function set_x_label_option($param) {
	$this->AxisX->setLabelOptions($param);
}

function set_y_label_option($param) {
	$this->AxisY->setLabelOptions($param);
}

function set_x_invert($param=true) {
	$this->AxisX->setInverted($param);
}

function set_y_invert($param=true) {
	$this->AxisY->setInverted($param);
}

function set_y_max($param=10) {
	$this->AxisY->forceMaximum($param);
}

function set_y_min($param=1) {
	$this->AxisY->forceMinimum($param);
}

function set_x_max($param=10) {
	$this->AxisX->forceMaximum($param);
}

function set_x_min($param=1) {
	$this->AxisX->forceMinimum($param);
}


function make_dataset() {
	return Image_Graph::factory('dataset');
}

function plot_graph($dataset,$kind='line',$color='red',$title='line',$axis='1st') {
	if($axis=='1st') {
		$plot_graph = $this->Plotarea->addNew($kind, array($dataset));
	} else {
		$plot_graph = $this->Plotarea->addNew($kind, array($dataset),IMAGE_GRAPH_AXIS_Y_SECONDARY);
	}
	$plot_graph->setLineColor($color); 
	$plot_graph->setTitle($title);
	return $plot_graph;
}

function plot_line_graph($dataset,$color='red',$title='line',$axis='1st') {
	return $this->plot_graph($dataset,'line',$color,$title,$axis);
}

function plot_bar_graph($dataset,$color='blue',$title='bar',$axis='1st') {
	return $this->plot_graph($dataset,'bar',$color,$title,$axis);
}

function plot_cross_scatter($dataset,$line_color='yellow',$fill_color='black',$title='cross',$axis='1st') {
	if($axis=='1st') {
		$plot_scatter = $this->Plotarea->addNew('scatter', array($dataset));
	} else {
		$plot_scatter = $this->Plotarea->addNew('scatter', array($dataset),IMAGE_GRAPH_AXIS_Y_SECONDARY);
	}
	$Marker = Image_Graph::factory('Image_Graph_Marker_Cross');
	$Marker->setFillColor($line_color);
	$Marker->setLineColor($fill_color);
	$plot_scatter->setMarker($Marker);
	$plot_scatter->setTitle($title);


}



function done($param) {
	return $this->Graph->done($param);
}


}
?>