<?php
/**
 *	Project:	Quicty: Quick application build environment depends on PEAR and Smarty
 *	File:		Plugin.class.php
 *
 *	@copyright	Tomoyuki Negishi and ZubaPitaTech, Inc.
 *	@author		Tomoyuki Negishi <tomoyu-n@zubapita.jp>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	Quicty
 *	@version	$Id:$
 */

abstract class QuictyPlugin extends Quicty{
	protected $contents_set;
	public $plugin_title = 'This Plugin Name';
	public $__page_obj;
	public $plugin_id = 0;

	function __construct($page_object,$params) {
		$this->params = $params;
		$this->__page_obj = $page_object;
	}

	public function get_id() {
		return $this->plugin_id;
	}

	public function get_title() {
		return $this->plugin_title;
	}
	
	public function get_contents() {
		if($this->contents_set) {
			$contents = $this->contents_set;
		} else {
			$contents = $this->make_contents();
			$this->contents_set = $contents;
		}
		return $contents;
	}

	protected function make_contents() {
		return '';
	}

	function __destruct() {
		// nothing to do
	}
}
?>