<?php
class user_list_options extends myQuicty {

function __construct($page) {
	parent::__construct();
	$this->page = $page;
	$this->list = $this->page->list;
}

var $perPage = 20;

function get_pager_option($add_condition='') {
	$where_condition = $this->make_where_condition($add_condition);
	$join_condition = $this->make_join_condition();
	$select_condition = $join_condition.' '.$where_condition;
	$pager_option = $this->set_pager_option($this->perPage,$select_condition);
	return $pager_option;
}

function make_where_condition($add_condition='') {
	$search_system = array(
		'keyword'=>array('handle'=>'userauth.handle'),
		'condition'=>array('id'=>'userauth.id'),
		'period'=>array('start_entry_datetime'=>array('column'=>'entry_datetime','end'=>'end_entry_datetime'))
		);
	return $this->list->make_condition($search_system,$add_condition);
}

function make_join_condition() {
	//$this->list->real_count = true; // set this flag if join other table
	//$joins[] = "LEFT JOIN {table_name} ON userauth.{table_name}_id={table_name}.id";
	//$join_condition = implode(' ',$joins);
	return $join_condition;
}

function make_select_fields() {
	$select_system = array(
		'userauth'=>'*',
		//'userauth'=>array('id','name','url'), // specify each column
		//'userauth'=>array('id'=>'userauth_id'), //specify another column name
		);
	return $this->list->make_select_fields($select_system);
}

function make_sort_condition() {
	$sort_system = array(
		'default'=>' order by id',
		// sort keys
		'columns'=>'*', // specify all column
		//'columns'=>array('id','name','url'), // specify each column
		);
	return $this->list->make_order($sort_system);
}

} // end of class user_list_options
?>