<?php

class import_app extends myQuicty {

function import_pages($app_root,$subdir,$application_id,$folder_id) {
	$lib_dir = "$app_root/lib/Pages";
	if($subdir) $lib_dir .= "/$subdir";
	$view_dir = "$app_root/view";
	if($subdir) $view_dir .= "/$subdir";
	
	$page = $this->new_data_set('page');
	foreach (glob("$lib_dir/*.class.php") as $filename) {
		list($page_name,$ext1,$ext2) = explode('.',basename($filename));
		if($page_name=='index' and $folder_id==0) {
			$my_folder_id = -1;
		} else {
			$my_folder_id = $folder_id;
		}
		$check = $page->select_table("where name='$page_name' and folder_id=$my_folder_id and application_id=$application_id");
		if(count($check)>0) continue;
		//if(file_exists("$view_dir/$page_name/info.html")) {
		//	$page_type = 2;
		//} else {
		//	$page_type = 1;
		//}
		$insert_set = array(
			'application_id'=>$application_id,
			'folder_id'=>$my_folder_id,
			'title'=>$page_name,
			'name'=>$page_name,
		//	'type'=>$page_type,
			);
		$result = $page->insert_table($insert_set);
	}
}

function import_datasets($app_root,$application_id,$db_name='') {
	$this->init_field_define();
	$def_dir = "$app_root/etc/data_def";
	foreach (glob("$def_dir/*.def") as $def_file_name) {
		$datasets_ids[] = $this->read_and_save_dataset($application_id,$def_file_name);
	}
	return $datasets_ids;
}

function read_and_save_dataset($application_id,$def_file_name,$new_dsn=array()) {
	$datasets = $this->new_data_set('datasets');
	$fields = $this->new_data_set('fields');

	// read data_set file
	$def_file = file_get_contents($def_file_name);
	$def = unserialize($def_file);
	//var_check($def);
	$dsn = $def['dsn'];

	// check uniqe
	$dataname = $new_dsn['dataname'] ? $new_dsn['dataname'] : $dsn['dataname'];
	$check = $datasets->select_table("where application_id=$application_id and name='".$dataname."'");
	if(count($check)>0) {
		$old_datasets_id = $check[0]['id'];
		$datasets->delete('where id='.$old_datasets_id);
		$fields->delete('where datasets_id='.$old_datasets_id);
	}
	
	$insert_set['application_id'] = $application_id;
	$insert_set['title'] = $new_dsn['title'] ? $new_dsn['title'] : $dsn['title'];
	$insert_set['name'] = $new_dsn['dataname'] ? $new_dsn['dataname'] : $dsn['dataname'];
	$insert_set['system'] = $new_dsn['system'] ? $new_dsn['system'] : $dsn['system'];
	$insert_set['dbname'] = $new_dsn['dbname'] ? $new_dsn['dbname'] : $dsn['dbname'];
	$insert_set['path'] = $new_dsn['path'] ? $new_dsn['path'] : $dsn['path'];
	$insert_set['host'] = $new_dsn['host'] ? $new_dsn['host'] : $dsn['host'];
	$insert_set['port'] = $new_dsn['port'] ? $new_dsn['port'] : $dsn['port'];
	$insert_set['user'] = $new_dsn['user'] ? $new_dsn['user'] : $dsn['user'];
	$insert_set['passowrd'] = $new_dsn['passowrd'] ? $new_dsn['passowrd'] : $dsn['passowrd'];
	$persistent = $field['persistent']=='yes' ? 1 : 0;
	$insert_set['persistent'] = isset($new_dsn['persistent']) ? $new_dsn['persistent'] : $persistent;
	$init_when_build = $field['init_when_build']=='no' ? 0 : 1;
	$insert_set['init_when_build'] = isset($new_dsn['init_when_build']) ? $new_dsn['init_when_build'] : $init_when_build;

	$result = $datasets->insert_table($insert_set);
	$datasets_id = $result['datasets']['id'];
	
	if($datasets_id) {
		$fieldset = $def['data_set'];
		$seq = 1;
		foreach($fieldset as $field) {
			$virtual = $field['virtual']=='yes' ? 1 : 0;
			switch($field['type']) {
				case 'id':
				case 'text':
				case 'select':
					$search_default = 1;
					break;
				default:
					$search_default = 0;
			}
			$search_flag = $field['search_flag']=='yes' ? 1 : $search_default;
			$sort_flag = $field['sort_flag']=='yes' ? 1 : 0;
			$properties = serialize($field);
			$hqf_type = $this->fields_reverse_map[$field['type']]['type'];
			$insert_set = array(
				'datasets_id'=>$datasets_id,
				'type'=>$field['type'],
				'hqf_type'=>$hqf_type,
				'name'=>$field['name'],
				'label'=>$field['label'],
				'virtual'=>$virtual,
				'properties'=>$properties,
				'search_flag'=>$search_flag,
				'sort_flag'=>$sort_flag,
				'seq'=>$seq,
			);
			$fields->insert_table($insert_set);
			$seq++;
		}
	}
	return $datasets_id;
}


} // end of class import_app

?>