/*
QVanaClock -- Vana'diel Clock for Zaurus SL-C Series.
Copyright (C) 2004 Gussan(http://sourceforge.jp/users/gsn/)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "qvsdatetime.h"

//վVana'diel[903/12/21() 1:56 <>] = Earth[2002/9/16 19:16:40]
QDateTime QVSDateTime::earthPointDT = QDateTime(QDate(2002,9,16),QTime(19,16,40));
// 900/1/1 00:00:00 	Ȥ̻(ʬ)
long QVSDateTime::vanaPointMin = 3*12*30*24*60 + 11*30*24*60 + 20*24*60 + 1*60 + 56;
// vana̻ÿεǯ(xx/1/1 00:00:00)
long QVSDateTime::vanaOrgYear = 900;

QString QVSDateTime::VanaWeekList[8] = {tr(""),tr(""),tr(""),tr(""),tr("ɹ"),tr(""),tr(""),tr("")};
QString QVSDateTime::VanaMoonList[12] = {tr(";"),tr("ϻ"),tr(""),tr(""),tr(""),tr("帹η"),tr(""),tr(""),tr(""),tr("ϻ"),tr("Է"),tr("η")};
long QVSDateTime::VanaWEAKList[8] = {4,5,0,1,3,2,7,6};

QString QVSDateTime::EarthWeekList[7] = {tr("Mon"),tr("Tue"),tr("Wed"),tr("Thu"),tr("Fri"),tr("Sat"),tr("Sun")};

QVSDateTime::QVSDateTime()
{
    m_orgFlg = 0;
    m_vanaDTmin = 0;

    m_vanaYear = 0;
    m_vanaMonth = 0;
    m_vanaDay = 0;
    m_vanaHour = 0;
    m_vanaMinute = 0;
    m_vanaSecond = 0;
    
    m_vanaDayofWeek = 0;
    m_vanaMoon = 0;
    m_vanaDayofMoon = 0;

}

void QVSDateTime::setEarthDateTime(QDateTime& earthdt)
{
    m_earthDT = earthdt;
    //m_vanaDTmin = earthPointDT.secsTo(earthdt)*25/60 + vanaPointMin;
    m_vanaDTmin = earthPointDT.secsTo(earthdt)/2.4 + vanaPointMin;

    // Vanaλ
    long vanamod = 0;
    m_vanaYear = m_vanaDTmin / (12*30*24*60) + vanaOrgYear;
    vanamod = m_vanaDTmin % (12*30*24*60);
    m_vanaMonth = vanamod / (30*24*60);
    vanamod = vanamod % (30*24*60);
    m_vanaDay = vanamod / (24*60);
    vanamod = vanamod % (24*60);
    m_vanaHour = vanamod / (60);
    m_vanaMinute = vanamod % (60);
    m_vanaSecond = 0;

    // Vanaλ
    long vanaDays = m_vanaDTmin / (24*60) + vanaOrgYear * (12*30);
    m_vanaDayofWeek = vanaDays % 8;
    m_vanaMoon = (vanaDays + 2) / 7 % 12;
    m_vanaDayofMoon = (vanaDays + 2) % 7;

    m_orgFlg = 1;

}

void QVSDateTime::setVanaDateTime(long year,long month,long day,long hour,long minute,long second)
{
    long vanamin = 0;

    m_vanaYear = year;
    vanamin = (year-vanaOrgYear) * (12*30*24*60);

    m_vanaMonth = month - 1;
    vanamin += m_vanaMonth * (30*24*60);
    m_vanaDay = day - 1;
    vanamin += m_vanaDay * (24*60);
    m_vanaHour = hour;
    vanamin += hour * 60;
    m_vanaMinute = minute;
    vanamin += minute;
    m_vanaSecond = second = 0;

    m_vanaDTmin = vanamin;

    // Earthλ
    //m_earthDT = earthPointDT.addSecs((m_vanaDTmin-vanaPointMin)*60/25);
    m_earthDT = earthPointDT.addSecs((m_vanaDTmin-vanaPointMin)*2.4);

    // Vanaλ
    //  뤿Ʒ׻
    long vanamod = 0;
    m_vanaYear = m_vanaDTmin / (12*30*24*60) + vanaOrgYear;
    vanamod = m_vanaDTmin % (12*30*24*60);
    m_vanaMonth = vanamod / (30*24*60);
    vanamod = vanamod % (30*24*60);
    m_vanaDay = vanamod / (24*60);
    vanamod = vanamod % (24*60);
    m_vanaHour = vanamod / (60);
    m_vanaMinute = vanamod % (60);
    m_vanaSecond = 0;

    // Vanaλ
    long vanaDays = m_vanaDTmin / (24*60) + vanaOrgYear * (12*30);
    m_vanaDayofWeek = vanaDays % 8;
    m_vanaMoon = (vanaDays + 2) / 7 % 12;

    m_orgFlg = 2;

}

