/*
QVanaClock -- Vana'diel Clock for Zaurus SL-C Series.
Copyright (C) 2004 Gussan(http://sourceforge.jp/users/gsn/)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef QVSDATETIME_H
#define QVSDATETIME_H

#include <qstring.h>
#include <qdatetime.h>
#include <qobject.h>

class QVSDateTime : public QObject
{
  public:
    static QDateTime earthPointDT;
    static long vanaPointMin;
    static long vanaOrgYear;
    static QString VanaWeekList[8];
    static QString VanaMoonList[12];
    static long VanaWEAKList[8];

    static QString EarthWeekList[7];// Mon=0...Sun=6

  private:
    int       m_orgFlg; //0:̵ 1:ϵ夬ꥸʥ 2:Vanaꥸʥ
    QDateTime m_earthDT;
    long      m_vanaDTmin; // Vana 900/1/1 00:00 origin

    long m_vanaYear;
    long m_vanaMonth; // 0 origin
    long m_vanaDay;   // 0 origin
    long m_vanaHour;
    long m_vanaMinute;
    long m_vanaSecond;

    long    m_vanaDayofWeek;  // 0 origin
    long    m_vanaMoon;       // 0 origin
    long    m_vanaDayofMoon;  // 0 origin

  public:
    QVSDateTime();
    void setEarthDateTime(QDateTime& earthdt);
    void setVanaDateTime(long year,long month,long day,long hour,long minute,long second);

    QDateTime earthDT(){return m_earthDT;};
    long vanaYear()    {return m_vanaYear;};
    long vanaMonth()   {return m_vanaMonth+1;};
    long vanaDay()     {return m_vanaDay+1;};
    long vanaHour()    {return m_vanaHour;};
    long vanaMinute()  {return m_vanaMinute;};
    long vanaSecond()  {return m_vanaSecond;};

    long    vanaDayofWeek()   {return m_vanaDayofWeek;};
    long    vanaMoon()        {return m_vanaMoon;};
    long    vanaDayofMoon()   {return m_vanaDayofMoon + 1;};
    QString vanaDayofWeekStr(){return VanaWeekList[m_vanaDayofWeek];};
    QString vanaMoonStr()     {return VanaMoonList[m_vanaMoon];};
    long    vanaWEAKWeek()    {return VanaWEAKList[m_vanaDayofWeek];};

};
#endif //QVSDATETIME_H
