/*
QVanaClock -- Vana'diel Clock for Zaurus SL-C Series.
Copyright (C) 2004 Gussan(http://sourceforge.jp/users/gsn/)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// ܸʸɡܸEUC
#include <qwidget.h>
#include <qstring.h>
#include <qlabel.h>
#include <qpalette.h>
#include <qrect.h>
#include <qlistview.h>
#include <qheader.h>
#include <qfont.h>
#include <qlist.h>
#include <qhbox.h>
#include <qgroupbox.h>
#include "qvsdatetime.h"

#ifndef QVSSHIP_H
#define QVSSHIP_H

class QVSShipTimeCalc
{
  private:
    int m_scheduleNum;
    QString* m_scheduleArrival;
    QString* m_scheduleDeparture;
    QString* m_scheduleArrivedist;
    QString* m_scheduleDepartureDisp;

    QDateTime m_currentDT;
    int m_listMax;
    QDateTime* earthDTScheduleArrival;
    QDateTime* earthDTScheduleDeparture;
    QDateTime* earthDTScheduleArrivedist;
    int* m_status;
    QString* m_strTimeOrder;
    QString* m_strSchedule;

  public:
    QVSShipTimeCalc(int scheduleNum,
                    QString* arrival,
                    QString* departure,
                    QString* arrivedist,
                    QString* departureDisp,
                    int listMax);
    int setCurrentDateTime(QDateTime& curDT);
    int getStatus(int listIndex){return m_status[listIndex];};
    long getRemainSec(int listIndex);
    QString getSchedule(int listIndex);

};

class QVSShipTimeData
{
  public:
    //塼
    //  ȯ
    static QString ArrivalJ2S[4];
    static QString ArrivalJ2B[4];
    static QString ArrivalJ2W[4];
    static QString ArrivalJ2K[4];
    static QString DepartureJ2S[4];
    static QString DepartureJ2B[4];
    static QString DepartureJ2W[4];
    static QString DepartureJ2K[4];
    static QString ArrivDestJ2S[4];
    static QString ArrivDestJ2B[4];
    static QString ArrivDestJ2W[4];
    static QString ArrivDestJ2K[4];
    static QString DepartureDispJ2S[4];
    static QString DepartureDispJ2B[4];
    static QString DepartureDispJ2W[4];
    static QString DepartureDispJ2K[4];
    //  ιԤ
    static QString ArrivalS2J[4];
    static QString ArrivalB2J[4];
    static QString ArrivalW2J[4];
    static QString ArrivalK2J[4];
    static QString DepartureS2J[4];
    static QString DepartureB2J[4];
    static QString DepartureW2J[4];
    static QString DepartureK2J[4];
    static QString ArrivDestS2J[4];
    static QString ArrivDestB2J[4];
    static QString ArrivDestW2J[4];
    static QString ArrivDestK2J[4];
    static QString DepartureDispS2J[4];
    static QString DepartureDispB2J[4];
    static QString DepartureDispW2J[4];
    static QString DepartureDispK2J[4];
    //  ӥʡݥޥ
    static QString ArrivalSM[3];
    static QString DepartureSM[3];
    static QString ArrivDestSM[3];

};

class QVSShipTimeTable : public QWidget
{
    Q_OBJECT
  protected:
    // ؽ̾
    static QString m_strOrder[4];

    // ׻
    QVSShipTimeCalc* m_calcShipSchedule[4];

    // ɽ
    QGroupBox* m_pMainBox;
    QLabel* m_pHeader[5]; // ɽФ
    QLabel* m_pShipItemDest[4]; // ɽ
    QLabel* m_pShipItem[8][4];//  ȯ Ļ 
    QFrame* m_pShipItemBox[8];
    QString m_sCityNameL[4];
    QString m_sCityNameS[4];
    QString m_sTitle;

  public:
    QVSShipTimeTable(QWidget* parent);
    void initbase();
    virtual void init()=0;
    void resizeLayout(int mode);
    void refresh();


};

//ȯ
class QVSShipTimeTableFromJ : public QVSShipTimeTable
{
  public:
    QVSShipTimeTableFromJ(QWidget* parent);
    void init();
};
//
class QVSShipTimeTableToJ : public QVSShipTimeTable
{
  public:
    QVSShipTimeTableToJ(QWidget* parent);
    void init();
};

#endif //QVSSHIP_H

