/**
 * Copyright (C) 2009 root42 Inc. All rights reserved.
 */
package jp.root42.r42fw.export.web.ui.components.scope;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.opensymphony.xwork2.util.ValueStack;


/**
 * {@link LocalVariableScope}のファクトリクラスです。
 * 
 * @since 1.0
 * @author root42 Inc.
 * @version $Id: LocalVariableScopeFactory.java 1 2009-07-01 06:44:12Z takahashikzn $
 */
public class LocalVariableScopeFactory {

    /** instance */
    private static LocalVariableScopeFactory instance =
        new LocalVariableScopeFactory();

    /***/
    protected LocalVariableScopeFactory() {
    }

    /**
     * このクラスのシングルトンインスタンスを返します。
     * 
     * @return instance
     */
    public static LocalVariableScopeFactory getInstance() {
        return instance;
    }

    /**
     * このクラスのシングルトンインスタンスをセットします。
     * 
     * @param instance
     * instance
     */
    public static void setInstance(final LocalVariableScopeFactory instance) {
        if (instance == null) {
            throw new IllegalArgumentException("instance is null");
        }

        LocalVariableScopeFactory.instance = instance;
    }

    /**
     * @param stack
     * stack
     * @param request
     * request
     * @param response
     * response
     * @return LocalVariableScope
     */
    public LocalVariableScope create(final ValueStack stack,
        final HttpServletRequest request, final HttpServletResponse response) {

        return new LocalVariableScopeImpl(stack);
    }
}
