/**
 * Copyright (C) 2009 root42 Inc. All rights reserved.
 */
package jp.root42.r42fw.export.web.ui.components.scope;

import java.util.HashMap;
import java.util.Map;

import com.opensymphony.xwork2.util.ValueStack;

import org.apache.commons.lang.StringUtils;


/**
 * {@link LocalVariableScope}のデフォルト実装です。
 * 
 * @since 1.0
 * @author root42 Inc.
 * @version $Id: LocalVariableScopeImpl.java 1 2009-07-01 06:44:12Z takahashikzn $
 */
public class LocalVariableScopeImpl
    implements LocalVariableScope {

    /** {@link #stack} */
    private final ValueStack stack;

    /** {@link #overridedVars} */
    private final Map<String, Object> overridedVars =
        new HashMap<String, Object>();
    /** {@link #overridedAttrVars} */
    private final Map<String, Object> overridedAttrVars =
        new HashMap<String, Object>();

    /**
     * @param stack
     * stack
     */
    protected LocalVariableScopeImpl(final ValueStack stack) {
        this.stack = stack;
    }

    /**
     * @return ValueStack
     */
    protected ValueStack getStack() {
        return this.stack;
    }

    /** {@inheritDoc} */
    @Override
    public void openScope() {
    }

    /** {@inheritDoc} */
    @Override
    public void closeScope() {

        // #attrの値を復元する
        for (final String key : this.overridedAttrVars.keySet()) {
            final Object value = this.overridedAttrVars.get(key);
            this.setAttrValue(key, value);
        }

        // ----
        // コンテキストの状態を復元する
        for (final String key : this.overridedVars.keySet()) {
            final Object value = this.overridedVars.get(key);
            this.setValue(key, value);
        }
    }

    /** {@inheritDoc} */
    @Override
    public void setVar(final String key, final Object value) {
        if (StringUtils.isBlank(key)) {
            return;
        }

        // ----
        // 現在のブロックにおける#attrの状態を記録しておく
        if (!this.overridedAttrVars.containsKey(key)) {
            final Object attrVar = this.getAttrValue(key);
            this.overridedAttrVars.put(key, attrVar);
        }

        this.setAttrValue(key, value);

        // ----
        // 現在のブロックにおけるコンテキストの状態を記録しておく
        if (!this.overridedVars.containsKey(key)) {
            final Object var = this.getValue(key);
            this.overridedVars.put(key, var);
        }

        this.setValue(key, value);
    }

    /**
     * @param key
     * key
     * @return value
     */
    protected Object getAttrValue(final String key) {
        return this.getStack().findValue("#attr['" + key + "']");
    }

    /**
     * @param key
     * key
     * @param value
     * value
     */
    protected void setAttrValue(final String key, final Object value) {
        this.getStack().setValue("#attr['" + key + "']", value, true);
    }

    /**
     * @param key
     * key
     * @return value
     */
    protected Object getValue(final String key) {
        return this.getStack().findValue("#" + key);
    }

    /**
     * @param key
     * key
     * @param value
     * value
     */
    protected void setValue(final String key, final Object value) {
        this.getStack().setValue("#" + key, value, true);
    }
}
