/**
 * Copyright (C) 2009 root42 Inc. All rights reserved.
 */
package jp.root42.r42fw.export.web.ui.components.scope;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.struts2.components.Component;


/**
 * @since 1.0
 * @author root42 Inc.
 * @version $Id: LocalVariableScopeUtil.java 3 2009-07-04 07:27:13Z takahashikzn $
 */
public final class LocalVariableScopeUtil {

    /***/
    private LocalVariableScopeUtil() {
    }

    /**
     * 現在のset-localタグを囲っているLocalVariableScopeを取得する。
     * 
     * @param thisComponent
     * thisComponent
     * @return LocalVariableScope
     * @throws IllegalStateException
     * LocalVariableScopeが見つからなかった場合
     */
    public static LocalVariableScope getEnclosingLocalVariableScope(
        final Component thisComponent) throws IllegalStateException {

        @SuppressWarnings("unchecked")
        final List<Component> componentStack =
            new ArrayList<Component>(thisComponent.getComponentStack());

        Collections.reverse(componentStack);

        for (final Component comp : componentStack) {
            if (comp instanceof LocalVariableScopeAware) {
                return ((LocalVariableScopeAware) comp).getLocalVariableScope();
            }
        }

        throw new IllegalStateException("<r:block> not found: "
            + componentStack);
    }
}
