/**
 * Copyright (C) 2009 root42 Inc. All rights reserved.
 */

/**
 * i荞ݑIXgB
 *
 * @author root42 Inc.
 * @since 1.0
 * @version $Id$
 */
function NarrowDownSelectionList(/* Document */ document) {

    /** {@link #this} */
    var self = this;

    /** document */
    /* Document */ self.document = document;

    /** listItemOfLevels */
    /* List<Map<String, Map<String, String>>> */ self.listItemOfLevels = [];

    /** paramName */
    /* String */ self.paramName = null;


    /**
     * ex̃XgvfW񂷂B
     *
     * @param level
     * ݂̃x
     *
     * @param thisLevelListItems
     * ݂̃x̃Xgvf
     */
    /* private Function */ var setupListItemOfLevel = /* void */ function(
        /* int */ level,
        /* String */ parentListItemKey,
        /* Map<String, Object> */ thisLevelListItems) {

        if (self.listItemOfLevels.length <= level) {
            self.listItemOfLevels.push({});
        }

        for (var listItemKey in thisLevelListItems) {
            var nextLevelListItem = thisLevelListItems[listItemKey];

            if (self.listItemOfLevels[level][parentListItemKey] == null) {
                self.listItemOfLevels[level][parentListItemKey] = {};
            }

            // qx݂ꍇ
            if (typeof(nextLevelListItem) == 'object') {
                self.listItemOfLevels[level][parentListItemKey][listItemKey] = "";
                setupListItemOfLevel(level + 1, listItemKey, nextLevelListItem);
            }

            // qx݂Al݂ꍇ
            else {
                self.listItemOfLevels[level][parentListItemKey][listItemKey] = "" + nextLevelListItem;
            }
        }
    };

    /**
     * Ή郌x̃XgvfێʂSelect^O쐬B
     *
     * @param thisLevelListItems
     * ݂̃x̃Xgvf
     */
    /* private Function */ var createNarrowDownSelect = function(
        /* Map<String, Map<String, String>> */ thisLevelListItems) {

        /* Function */ var createOption = /* Option */ function(/* String */ text, /* String */ value) {

            //IEƂ̂ł͓Ȃ
            //return new Option(text, value);

            /* Option */ var option = self.document.createElement("option");

            //IEƂ̓_
            //option.text = text;

            option.appendChild(self.document.createTextNode(text));
            option.value = value;

            return option;
        };

        /* Function */ var createOptions = /* List<Option> */ function(/* String */ listItemKey) {
            /* List<Option> */ var options = [ new Option("@", "") ];

            /* Map<String, String> */ var newListItems = thisLevelListItems[listItemKey];

            if (newListItems != null) {
                for (/* String */ var newListItemKey in newListItems) {
                    options.push(createOption(newListItemKey, newListItems[newListItemKey]));
                }
            }

            return options;
        };


        /* Select */ var selectElem = self.document.createElement("select");
        // IEł́AԂoptionŒĂȂƃTCYvZB1
        selectElem.appendChild(createOption("@", ""));

        selectElem.notifyParentChanged = /* void */ function(/* String */ parentListItem) {
//alert("notifyParentChanged: " + selectElem.id);
            selectElem.options.length = 0;

            for (/* String */ var listItemKey in thisLevelListItems) {
                if (listItemKey == parentListItem) {
                    /* List<Option> */ var newOptions = createOptions(parentListItem);

                    for (/* int */ var i = 0; i < newOptions.length; i++) {
                        selectElem.appendChild(newOptions[i]);
                    }

                    selectElem.options[0].selected = true;

                    break;
                }
            }

            // IEł́AԂoptionŒĂȂƃTCYvZB2
            if (selectElem.options.length == 0) {
                selectElem.appendChild(createOption("@", ""));
            }

            // onchangeCxgʂ֔h
            if (selectElem.onchange != null) {
                selectElem.onchange();
            }
        };

        return selectElem;
    };

    /**
     * Xg̗vfݒ肷B
     *
     * @param listItems Xg̗vf
     */
    self.setListItems = /* void */ function(/* Map<String, Object> */ listItems) {
        setupListItemOfLevel(0, NarrowDownSelectionList.ROOT_SELECT_NAME, listItems);
    };

    /**
     * p[^ݒ肷B
     *
     * @param paramName p[^
     */
    self.setParamName = /* void */ function(/* String */ paramName) {
        self.paramName = paramName;
    };

    /**
     * i荞݃Xg`悷B
     */
    self.createNarrowDownSelectListElement = /* Element */ function() {
        /* Element */ var div = self.document.createElement("div");

        // SĂ̍i荞selectvfB
        // HTMLappendChildOiKł́AgetElementById͎gȂׂɗpӂĂB
        var narrowDownSelectElems = {};

        for (/* int */ var i = 0; i < self.listItemOfLevels.length; i++) {

            // eϐeXi[ɕXR[vɂ邽߂ɂ́Avar̃XR[v肷KvB
            (function() {
                /* Select */ var narrowDownSelect = createNarrowDownSelect(self.listItemOfLevels[i]);
                /* String */ var elemId = self.paramName + "_" + i;

                narrowDownSelectElems[elemId] = narrowDownSelect;
                narrowDownSelect.id = elemId;

                /* boolean */ var isLastSelect = (i == (self.listItemOfLevels.length - 1));
                if (isLastSelect) {
                    narrowDownSelect.name = self.paramName;
                } else {
                    /* String */ var childElemId = self.paramName + "_" + (i + 1);

                    // onchange𖾎IɌĂԕKv̂ŁAUtils.addEventListener͎gȂB
                    narrowDownSelect.onchange = /* void */ function() {
                        /* Select */ var parentSelectElem = narrowDownSelect;
                        /* Select */ var childSelectElem = narrowDownSelectElems[childElemId];

                        /* String */ var selectedKey = null;
                        if (0 <= parentSelectElem.selectedIndex) {
                            selectedKey = parentSelectElem.options[parentSelectElem.selectedIndex].text;
                        }

                        childSelectElem.notifyParentChanged(selectedKey);
                    };
                }

                // ----
                // span쐬div֒ǉB
                /* Element */ var span = self.document.createElement("span");
                span.appendChild(narrowDownSelect);

                div.appendChild(span);
                div.appendChild(self.document.createTextNode("@@"));
            })();
        }


        // i荞݃XgB
        var firstSelectElem = narrowDownSelectElems[self.paramName + "_0"];
        firstSelectElem.notifyParentChanged(NarrowDownSelectionList.ROOT_SELECT_NAME);


        return div;
    };
}


/**
 * 萔錾
 */
(function() {
    NarrowDownSelectionList.ROOT_SELECT_NAME = "/";
})();
