/**
 * Copyright (C) 2009 root42 Inc. All rights reserved.
 */

/**
 * R42t[[N
 *
 * i荞ݑIXgB
 *
 * @author root42 Inc.
 * @since 1.0
 * @version $Id: NarrowDownSelectionList.js 2240 2009-09-21 04:32:36Z kaz $
 */
function NarrowDownSelectionList(/* Document */ document) {

    /** {@link #this} */
    var self = this;

    /** document */
    /* Document */ self.document = document;

    /** listItemOfLevels */
    /* List<Map<String, Map<String, String>>> */ self.listItemOfLevels = [];

    /** paramName */
    /* String */ self.paramName = null;

    /** initialvalue */
    /* String */ self.initialValue = null;


    /**
     * Xg̗vfݒ肷B
     *
     * @param listItems Xg̗vf
     */
    self.setListItems = /* void */ function(/* Map<String, Object> */ listItems) {
        setupListItemOfLevel(0, NarrowDownSelectionList.ROOT_SELECT_NAME, listItems);
    };

    /**
     * p[^ݒ肷B
     *
     * @param paramName p[^
     */
    self.setParamName = /* void */ function(/* String */ paramName) {
        self.paramName = paramName;
    };

    /**
     * lݒ肷B
     *
     * @param initialValue l
     */
    self.setInitialValue = /* void */ function(/* String */ initialValue) {
        self.initialValue = initialValue;
    };


    /**
     * ex̃XgvfW񂷂B
     *
     * @param level
     * ݂̃x
     *
     * @param thisLevelListItems
     * ݂̃x̃Xgvf
     */
    /* private Function */ var setupListItemOfLevel = /* void */ function(
        /* int */ level,
        /* String */ parentListItemKey,
        /* Map<String, Object> */ thisLevelListItems) {

        if (self.listItemOfLevels.length <= level) {
            self.listItemOfLevels.push({});
        }

        for (var listItemKey in thisLevelListItems) {
            var nextLevelListItem = thisLevelListItems[listItemKey];

            if (self.listItemOfLevels[level][parentListItemKey] == null) {
                self.listItemOfLevels[level][parentListItemKey] = {};
            }

            // qx݂ꍇ
            if (typeof(nextLevelListItem) == 'object') {
                self.listItemOfLevels[level][parentListItemKey][listItemKey] = "";
                setupListItemOfLevel(level + 1, listItemKey, nextLevelListItem);
            }

            // qx݂Al݂ꍇ
            else {
                self.listItemOfLevels[level][parentListItemKey][listItemKey] = "" + nextLevelListItem;
            }
        }
    };

    /**
     * Ή郌x̃XgvfێʂSelect^O쐬B
     *
     * @param thisLevelListItems
     * ݂̃x̃Xgvf
     */
    /* private Function */ var createNarrowDownSelect = /* Select */ function(
        /* Map<String, Map<String, String>> */ thisLevelListItems) {

        /* Function */ var createOption = /* Option */ function(/* String */ text, /* String */ value) {

            //IEƂ̂ł͓Ȃ
            //return new Option(text, value);

            /* Option */ var option = self.document.createElement("option");

            //IEƂ̓_
            //option.text = text;

            option.appendChild(self.document.createTextNode(text));
            option.value = value;

            return option;
        };

        /* Function */ var createOptions = /* List<Option> */ function(/* String */ listItemKey) {
            /* List<Option> */ var options = [ new Option("@", "") ];

            /* Map<String, String> */ var newListItems = thisLevelListItems[listItemKey];

            if (newListItems != null) {
                for (/* String */ var newListItemKey in newListItems) {
                    options.push(createOption(newListItemKey, newListItems[newListItemKey]));
                }
            }

            return options;
        };


        /* Select */ var selectElem = self.document.createElement("select");
        // IEł́AԂoptionŒĂȂƃTCYvZB1
        selectElem.appendChild(createOption("@", ""));

        selectElem.notifyParentChanged = /* void */ function(/* String */ parentListItem) {
//alert("notifyParentChanged: " + selectElem.id);
            selectElem.options.length = 0;

            for (/* String */ var listItemKey in thisLevelListItems) {
                if (listItemKey == parentListItem) {
                    /* List<Option> */ var newOptions = createOptions(parentListItem);

                    for (/* int */ var i = 0; i < newOptions.length; i++) {
                        selectElem.appendChild(newOptions[i]);
                    }

                    break;
                }
            }

            // IEł́AԂoptionŒĂȂƃTCYvZB2
            if (selectElem.options.length == 0) {
                selectElem.appendChild(createOption("@", ""));
            }

            // I1ȂꍇAŏIԂɂ
            if (selectElem.options.length == 2) {
                selectElem.options[1].selected = true;
            }

            // onchangeCxgʂ֔h
            if (selectElem.onchange != null) {
                selectElem.onchange();
            }
        };

        return selectElem;
    };

    /**
     * lIԂ𕜌B
     *
     * @param narrowDownSelectElems
     * i荞݃ZNg^ÕXg
     *
     * @param initialValue
     * l
     */
    /* private Function */ var restoreState = function(
        /* List<Select> */ narrowDownSelectElems, /* String */ initialValue) {

        // IꂽL[̃XgB
        /* List<String> */ var selectedKeys = [];

        // uIꂽvƂ݂Ȃǂ̃}b`B
        /* Function */ var defaultMatcher = /* boolean */ function(
            /* String */ selectedKey, /* String */ childKey, /* String */ childValue) {
            return selectedKey == childKey;
        };

        // IꂽL[̃Xg\B
        /* private Function */ var restoreState0 = /* void */ function(
            /* int */ level, /* String */ selectedKey, /* Function */ matcher) {

            /* Map<String, Map<String, String>> */ var listItemOfLevel = self.listItemOfLevels[level];

            for (/* String */ var parentKey in listItemOfLevel) {
                /* String */ var childListItem = listItemOfLevel[parentKey];

                for (/* String */ var childKey in childListItem) {
                    if (matcher(selectedKey, childKey, childListItem[childKey])) {
                        selectedKeys.push(childKey);

                        if (0 < level) {
                            restoreState0((level - 1), parentKey, defaultMatcher);
                            return;
                        }
                    }
                }
            }
        };

        
        // ŉwx̓L[łȂĒlƃ}b`B
        /* Function */ var lastLevelMatcher = /* boolean */ function(
            /* String */ selectedKey, /* String */ childKey, /* String */ childValue) {
            return selectedKey == childValue;
        };
        restoreState0((self.listItemOfLevels.length - 1), initialValue, lastLevelMatcher);


        // gbvx珇ɑIԂ𕜌
        top:
        for (/* int */ var i = 0; i < narrowDownSelectElems.length; i++) {
            /* Select */ var narrowDownSelectElem = narrowDownSelectElems[i];

            for (/* int */ var k = 0; k < selectedKeys.length; k++) {

                /* String */ var selectedKey = selectedKeys[k];
                for (/* int */ var m = 0; m < narrowDownSelectElem.options.length; m++) {

                    if (narrowDownSelectElem.options[m].innerHTML == selectedKey) {
                        narrowDownSelectElem.options[m].selected = true;

                        // qxoption^O𐶐
                        if (narrowDownSelectElem.onchange != null) {
                            narrowDownSelectElem.onchange();
                        }
                        
                        continue top;
                    }
                }
            }
        }
    };

    /**
     * i荞݃Xg`悷B
     */
    self.createNarrowDownSelectListElement = /* Element */ function() {
        /* Element */ var div = self.document.createElement("div");

        // SĂ̍i荞selectvfB
        // HTMLappendChildOiKł́AgetElementById͎gȂׂɗpӂĂB
        var narrowDownSelectElems = new Array();

        for (/* int */ var i = 0; i < self.listItemOfLevels.length; i++) {

            // eϐeXi[ɕXR[vɂ邽߂ɂ́Avar̃XR[v肷KvB
            (function() {
                /* int */ var level = i;
                /* Select */ var narrowDownSelect = createNarrowDownSelect(self.listItemOfLevels[level]);
                /* String */ var elemId = self.paramName + "_" + level;

                narrowDownSelectElems[level] = narrowDownSelect;
                narrowDownSelect.id = elemId;

                /* boolean */ var isLastSelect = (level == (self.listItemOfLevels.length - 1));
                if (isLastSelect) {
                    narrowDownSelect.name = self.paramName;
                } else {
                    /* String */ var childElemId = self.paramName + "_" + (level + 1);

                    // onchange𖾎IɌĂԕKv̂ŁAUtils.addEventListener͎gȂB
                    narrowDownSelect.onchange = /* void */ function() {
                        /* Select */ var parentSelectElem = narrowDownSelect;
                        /* Select */ var childSelectElem = narrowDownSelectElems[level + 1];

                        /* String */ var selectedKey = null;
                        if (0 <= parentSelectElem.selectedIndex) {
                            selectedKey = parentSelectElem.options[parentSelectElem.selectedIndex].text;
                        }

                        childSelectElem.notifyParentChanged(selectedKey);
                    };
                }

                // ----
                // span쐬div֒ǉB
                /* Element */ var span = self.document.createElement("span");
                span.appendChild(narrowDownSelect);

                div.appendChild(span);
                div.appendChild(self.document.createTextNode("@@"));
            })();
        }


        // i荞݃XgB
        var firstSelectElem = narrowDownSelectElems[0];
        firstSelectElem.notifyParentChanged(NarrowDownSelectionList.ROOT_SELECT_NAME);


        // lȂԂ𕜌
        if (self.initialValue != null) {
            restoreState(narrowDownSelectElems, self.initialValue);
        }

        return div;
    };
}


/**
 * 萔錾
 */
(function() {
    NarrowDownSelectionList.ROOT_SELECT_NAME = "/";
})();
