/**
 * Copyright (C) 2009 root42 Inc. All rights reserved.
 */

/**
 * R42t[[N
 *
 * i荞ݑIXgB
 *
 * @author root42 Inc.
 * @since 1.0
 * @version $Id: NarrowDownSelectionList.js 2357 2009-10-06 10:32:18Z kaz $
 */
function NarrowDownSelectionList(/* Document */ document) {

    /** {@link #this} */
    var self = this;

    /** document */
    /* Document */ self.document = document;

    /** listItemOfLevels */
    /* Map<String, Object> */ self.listItems = {};

    /** paramName */
    /* String */ self.paramName = null;

    /** initialvalue */
    /* String */ self.initialValue = null;


    /**
     * Xg̗vfݒ肷B
     *
     * @param listItems Xg̗vf
     */
    self.setListItems = /* void */ function(/* Map<String, Object> */ listItems) {
        self.listItems = listItems;
    };

    /**
     * p[^ݒ肷B
     *
     * @param paramName p[^
     */
    self.setParamName = /* void */ function(/* String */ paramName) {
        self.paramName = paramName;
    };

    /**
     * lݒ肷B
     *
     * @param initialValue l
     */
    self.setInitialValue = /* void */ function(/* String */ initialValue) {
        self.initialValue = initialValue;
    };

    /**
     * Optionvf쐬B
     *
     * @param text
     * @param value
     * @return OptionvfB
     */
    /* private Function */ var createOption = /* Option */ function(/* String */ text, /* String */ value) {

        //IEƂ̂ł͓Ȃ
        //return new Option(text, value);

        /* Option */ var option = self.document.createElement("option");

        //IEƂ̓_
        //option.text = text;

        option.appendChild(self.document.createTextNode(text));
        option.value = value;

        return option;
    };

    /**
     * Selectvf쐬B
     *
     * @return SelectvfB
     */
    /* private Function */ var createEmptySelect = /* Selectd */ function() {
        /* Select */ var selectElem = self.document.createElement("select");

        selectElem.setOptions = /* void */ function(/* Map<String, Object> */ listItems) {
            if (!listItems) {
                listItems = {};
            }

            // optionS
            selectElem.options.length = 0;
            // 擪ɋI
            selectElem.appendChild(createOption(NarrowDownSelectionList.EMPTY_VALUE, ""));

            // IXgpɎĝŕێĂB
            selectElem.listItems = listItems;

            for (/* String */ var listItemKey in listItems) {
                /* Object */ var listItemValue = listItems[listItemKey];

                if (typeof(listItemValue) == 'object') {
                    listItemValue = "";
                }

                selectElem.appendChild(
                    createOption(listItemKey, listItemValue));
            }

            // IȂꍇAIԂɂ
            if (selectElem.options.length == 2) {
                selectElem.options[1].selected = true;
            }
        };

        return selectElem;
    }

    /**
     * i荞݃Xg̍ő[擾B
     *
     * @param listItems Xg̗vf
     * @return i荞݃Xg̍ő[BŒ1B
     */
    /* private Function */ var countMaxDepth = /* int */ function(/* Map<String, Object> */ listItems) {
        /* int */ var maxDepth = 1;

        for (/* String */ var listItemKey in listItems) {
            (function() {
                /* Object */ var listItemValue = listItems[listItemKey];

                if (typeof(listItemValue) == 'object') {
                    /* int */ var depth = countMaxDepth(listItemValue);

                    if (maxDepth <= depth) {
                        maxDepth = (depth + 1);
                    }
                }
            })();
        }

        return maxDepth;
    };

    /**
     * l𕜌B
     *
     * @param narrowDownSelects
     * @param initialValue
     */
    /* private Function */ var restoreSelectionState = function(/* List<Select> */ narrowDownSelects, /* Object */ initialValue) {

        // IꂽL[̃Xg
        /* List<String> */ var selectedItemKeys = [];

        /**
         * IꂽL[̃Xg\B
         *
         * @param listItems Xg̗vf
         */
        /* Function */ var searchSelectedKeys = function(/* Map<String, Object> */ listItems) {

            for (/* String */ var listItemKey in listItems) {
                selectedItemKeys.push(listItemKey);

                /* Object */ var listItemValue = listItems[listItemKey];

                if (listItemValue == initialValue) {
                    // Eo
                    throw 0;
                } else if (typeof(listItemValue) == 'object') {
                    searchSelectedKeys(listItemValue);
                }

                selectedItemKeys.pop();
            }
        };


        try {
            searchSelectedKeys(self.listItems);
        } catch(e) {
            // EoȊOȂăX[
            if (e != 0) {
                throw e;
            }
        }


        // IꂽL[̒TɎsꍇ͉Ȃ
        if (selectedItemKeys.length != narrowDownSelects.length) {
            return;
        }


        for (/* int */ var i = 0; i < selectedItemKeys.length; i++) {
            /* String */ var selectedItemKey = selectedItemKeys[i];
            /* Select */ var selectElem = narrowDownSelects[i];

            for (/* int */ var k = 0; k < selectElem.options.length; k++) {
                /* Option */ var option = selectElem.options[k];

                if (option.innerHTML == selectedItemKey) {
                    option.selected = true;
                    selectElem.onchange();

                    break;
                }
            }
        }
    };

    /**
     * i荞ݑIXg܂ރm[h쐬B
     *
     * @return i荞ݑIXg܂ރm[hB
     */
    self.createNarrowDownSelectListElement = function() {
        /* Element */ var div = self.document.createElement("div");
        /* var */ var maxDepth = countMaxDepth(self.listItems);
        /* var */ var narrowDownSelects = [];

        for (/* int */ var i = 0; i < maxDepth; i++) {

            (function() {
                /* int */ var depth = i;
                /* Select */ var narrowDownSelect = createEmptySelect();

                /* boolean */ var isFirstDepth = (depth == 0);
                if (isFirstDepth) {
                    narrowDownSelect.setOptions(self.listItems);
                }

                narrowDownSelect.onchange= /* void */ function() {
                    /* Option */ var selectedOption = narrowDownSelect.options[narrowDownSelect.selectedIndex];
                    /* Map<String, Object> */ var listItems = narrowDownSelect.listItems[selectedOption.text];

                    /* boolean */ var isLastDepth = (narrowDownSelects.length == (depth + 1));

                    if (!isLastDepth) {
                        /* Select */ var nextDepthNarrowDownSelect = narrowDownSelects[depth + 1];
                        nextDepthNarrowDownSelect.setOptions(listItems);

                        // SelectփCxg`d
                        nextDepthNarrowDownSelect.onchange();
                    }
                };

                narrowDownSelects.push(narrowDownSelect);

                // ----
                // span쐬div֒ǉB
                /* Element */ var span = self.document.createElement("span");
                span.appendChild(narrowDownSelect);

                div.appendChild(span);
                div.appendChild(self.document.createTextNode("@"));
            })();
        }

        // p[^Zbg
        narrowDownSelects[narrowDownSelects.length - 1].name = self.paramName;

        // lΏԂ𕜌
        if (!!self.initialValue) {
            restoreSelectionState(narrowDownSelects, self.initialValue);
        }

        return div;
    };
}


/**
 * 萔錾
 */
(function() {
    NarrowDownSelectionList.EMPTY_VALUE = "@@@";
})();
