/*
 * Copyright (C) 2010 root42 Inc. All rights reserved.
 */

/**
 * R42フレームワーク
 *
 * 汎用ユーティリティ。
 *
 * @author root42 Inc.
 * @version $Id: Utils.js 2625 2010-01-22 09:31:50Z kaz $
 */

var Utils = {};


/**
 * 指定したノードへイベントリスナーを追加します。
 *
 * <p>
 * この関数は、ノードのハンドラへ関数を直接セットします。
 * この関数を呼び出し後、明示的にハンドラをnullにすると
 * この関数で行った処理はすべて無効となりますので注意が必要です。
 * </p>
 *
 * <p>
 * 例えば、
 * <pre>
 * Utils.addEventListener(node, "change", function() { ... });
 * </pre>
 * とした後で、
 * <pre>
 * node.onchange = function() { ... };
 * </pre>
 * としてしまうと、addEventListenerでセットしたハンドラは無効になります。
 * </p>
 *
 * @param node
 * ノード
 * @param eventName
 * イベント名("click", "change", "mouseover", ...)
 * @param listener
 * イベントリスナー関数
 * @throws Error いずれかの引数が<code>null</code>の場合
 */
Utils.addEventListener = /* void */ function(
    /* Node */ node, /* String */ eventName, /* Function */ listener) {

    if (eventName == null) {
        throw new Error("eventName is null");
    } else if (listener == null) {
        throw new Error("listener is null");
    }

    /* String */ var listenersName = "__listeners__";
    /* String */ var handlerName = "on" + eventName;

    // 専用関数未セット
    if (node[handlerName] == null) {
        node[handlerName] = /* void */ function() {
            for (/* int */ var i = 0; i < this[handlerName][listenersName].length; i++) {
                this[handlerName][listenersName][i]();
            }
        };

        node[handlerName][listenersName] = [ listener ];
    }

    // 通常の関数がセット済み
    else if (node[handlerName][listenersName] == null) {
        /* Function */ var oldHandler = node[handlerName];

        node[handlerName] = /* void */ function() {
            for (/* int */ var i = 0; i < this[handlerName][listenersName].length; i++) {
                this[handlerName][listenersName][i]();
            }
        };

        node[handlerName][listenersName] = [ oldHandler, listener ];
    }

    // 専用関数がセット済み
    else {
        node[handlerName][listenersName].push(listener);
    }
};


/**
 * 文字列がnullまたはから文字であるか判定します。
 *
 * @param text
 * 文字列
 */
Utils.isEmptyString = /* boolean */ function(/* String */ text) {
    ArgContract.isTypeof("text", "string", text);

    return (text == null) || (text == "");
};


/**
 * ノードの子要素をすべて削除します。
 *
 * @param elem
 * 親要素
 */
Utils.clearChildNodes = /* void */ function(/* Node */ elem) {
    elem.innerHTML = "";

    // while (0 < elem.childNodes.length) { elem.removeChild(elem.childNodes[0]); }
};


/**
 * Option要素を作成する。
 *
 * @param document
 * @param text
 * @param value
 * @return Option要素。
 */
Utils.createOption = /* Option */ function(/* Document */ document, /* String */ text, /* String */ value) {

    ArgContract.notNull("document", document);

    //IEだとこのやり方では動かない
    //return new Option(text, value);

    /* Option */ var option = document.createElement("option");

    //IEだとこれはダメ
    //option.text = text;

    option.appendChild(document.createTextNode(text));
    option.value = value;

    return option;
};
