/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.bean.conf.loader.annotation.handler;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import org.springframework.util.StringUtils;
import org.springmodules.validation.bean.conf.MutableBeanValidationConfiguration;
import org.springmodules.validation.bean.conf.loader.annotation.handler.PropertyValidationAnnotationHandler;
import org.springmodules.validation.bean.rule.AbstractValidationRule;
import org.springmodules.validation.bean.rule.PropertyValidationRule;
import org.springmodules.validation.bean.rule.resolver.ErrorArgumentsResolver;
import org.springmodules.validation.bean.rule.resolver.FunctionErrorArgumentsResolver;
import org.springmodules.validation.util.cel.ConditionExpressionBased;
import org.springmodules.validation.util.cel.ConditionExpressionParser;
import org.springmodules.validation.util.cel.valang.ValangConditionExpressionParser;
import org.springmodules.validation.util.condition.Condition;
import org.springmodules.validation.util.fel.FunctionExpressionBased;
import org.springmodules.validation.util.fel.FunctionExpressionParser;
import org.springmodules.validation.util.fel.parser.ValangFunctionExpressionParser;

public abstract class AbstractPropertyValidationAnnotationHandler
implements PropertyValidationAnnotationHandler,
ConditionExpressionBased,
FunctionExpressionBased {
    public static final String APPLY_IF_ATTR = "applyIf";
    public static final String ERROR_CODE_ATTR = "errorCode";
    public static final String MESSAGE_ATTR = "message";
    public static final String ARGS_ATTR = "args";
    public static final String CONTEXTS_ATTR = "contexts";
    private Class[] supportedAnnotationTypes;
    private ConditionExpressionParser conditionExpressionParser;
    private FunctionExpressionParser functionExpressionParser;

    public AbstractPropertyValidationAnnotationHandler(Class ... supportedAnnotationTypes) {
        this.supportedAnnotationTypes = supportedAnnotationTypes;
        this.conditionExpressionParser = new ValangConditionExpressionParser();
        this.functionExpressionParser = new ValangFunctionExpressionParser();
    }

    public boolean supports(Annotation annotation, Class clazz, PropertyDescriptor descriptor) {
        for (Class supportedType : this.supportedAnnotationTypes) {
            if (!supportedType.isInstance(annotation)) continue;
            return true;
        }
        return false;
    }

    public void handleAnnotation(Annotation annotation, Class clazz, PropertyDescriptor descriptor, MutableBeanValidationConfiguration configuration) {
        String[] applicableContexts;
        Condition applicabilityCondition;
        ErrorArgumentsResolver argumentsResolver;
        String message;
        AbstractValidationRule rule = this.createValidationRule(annotation, clazz, descriptor.getName());
        String errorCode = this.extractErrorCode(annotation);
        if (errorCode != null) {
            rule.setErrorCode(errorCode);
        }
        if ((message = this.extractDefaultMessage(annotation)) != null) {
            rule.setDefaultErrorMessage(message);
        }
        if ((argumentsResolver = this.extractArgumentsResolver(annotation)) != null) {
            rule.setErrorArgumentsResolver(argumentsResolver);
        }
        if ((applicabilityCondition = this.extractApplicabilityContidion(annotation)) != null) {
            rule.setApplicabilityCondition(applicabilityCondition);
        }
        if ((applicableContexts = this.extractApplicableContexts(annotation)) != null) {
            rule.setContextTokens(applicableContexts);
        }
        if (this.isConditionGloballyScoped(annotation)) {
            configuration.addPropertyRule(descriptor.getName(), rule);
        } else {
            PropertyValidationRule propertyRule = new PropertyValidationRule(descriptor.getName(), rule);
            if (applicabilityCondition != null) {
                propertyRule.setApplicabilityCondition(applicabilityCondition);
            }
            configuration.addPropertyRule(descriptor.getName(), propertyRule);
        }
    }

    protected String extractErrorCode(Annotation annotation) {
        return (String)this.extractAnnotationAttribute(annotation, ERROR_CODE_ATTR);
    }

    protected String extractDefaultMessage(Annotation annotation) {
        return (String)this.extractAnnotationAttribute(annotation, MESSAGE_ATTR);
    }

    protected ErrorArgumentsResolver extractArgumentsResolver(Annotation annotation) {
        String argsAsString = (String)this.extractAnnotationAttribute(annotation, ARGS_ATTR);
        argsAsString = argsAsString == null ? "" : argsAsString;
        String[] argsExpressions = StringUtils.commaDelimitedListToStringArray((String)argsAsString);
        if (argsExpressions.length == 0) {
            return null;
        }
        return new FunctionErrorArgumentsResolver(argsExpressions, this.functionExpressionParser);
    }

    protected Condition extractApplicabilityContidion(Annotation annotation) {
        String expression = (String)this.extractAnnotationAttribute(annotation, APPLY_IF_ATTR);
        return StringUtils.hasText((String)expression) ? this.conditionExpressionParser.parse(expression) : null;
    }

    protected String[] extractApplicableContexts(Annotation annotation) {
        String[] contexts = (String[])this.extractAnnotationAttribute(annotation, CONTEXTS_ATTR);
        return contexts.length > 0 ? contexts : null;
    }

    protected boolean isConditionGloballyScoped(Annotation annotation) {
        return false;
    }

    protected abstract AbstractValidationRule createValidationRule(Annotation var1, Class var2, String var3);

    public void setConditionExpressionParser(ConditionExpressionParser conditionExpressionParser) {
        this.conditionExpressionParser = conditionExpressionParser;
    }

    protected ConditionExpressionParser getConditionExpressionParser() {
        return this.conditionExpressionParser;
    }

    public void setFunctionExpressionParser(FunctionExpressionParser functionExpressionParser) {
        this.functionExpressionParser = functionExpressionParser;
    }

    protected FunctionExpressionParser getFunctionExpressionParser() {
        return this.functionExpressionParser;
    }

    protected Object extractAnnotationAttribute(Annotation annotation, String attributeName) {
        try {
            return annotation.getClass().getMethod(attributeName, new Class[0]).invoke((Object)annotation, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Expecting attribute '" + attributeName + "' in annotation '" + annotation.getClass().getName() + "'", e);
        }
    }
}

