/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.valang.functions;

import org.springframework.util.Assert;
import org.springmodules.validation.valang.ValangException;
import org.springmodules.validation.valang.functions.Function;
import org.springmodules.validation.valang.functions.FunctionCallback;
import org.springmodules.validation.valang.functions.FunctionTemplate;

public abstract class AbstractInitializableFunction
implements Function {
    private Function[] arguments;
    private FunctionTemplate functionTemplate;

    protected AbstractInitializableFunction() {
    }

    protected AbstractInitializableFunction(Function[] arguments, int line, int column) {
        this.init(arguments, line, column);
    }

    public void init(Function[] arguments, int line, int column) {
        Assert.state((this.arguments == null ? 1 : 0) != 0, (String)"Function already initialized");
        Assert.notNull((Object)arguments, (String)"The arguments of a function cannot be null");
        try {
            this.validateArguments(arguments);
        }
        catch (Throwable t) {
            throw new ValangException(t, line, column);
        }
        this.arguments = arguments;
        this.functionTemplate = new FunctionTemplate(line, column);
    }

    public Object getResult(Object target) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Function " + this + "' is not initialized. init(Function[]) " + "must be called in order to initialize a function");
        }
        return this.functionTemplate.execute(target, new FunctionCallback(){

            public Object execute(Object target) throws Exception {
                return AbstractInitializableFunction.this.getResult(target, AbstractInitializableFunction.this.arguments);
            }
        });
    }

    protected abstract void validateArguments(Function[] var1) throws RuntimeException;

    protected abstract Object getResult(Object var1, Function[] var2);

    public Function[] getArguments() {
        return this.arguments;
    }

    protected boolean isInitialized() {
        return this.arguments != null;
    }
}

