#ifndef _CAVE_H_
#define _CAVE_H_

enum {
  MAP_W = 50,
  MAP_H = 40
};

struct _coord{
  int x, y;
};
 
struct _rect {
  gboolean cant_split_vertical;
  gboolean cant_split_horizonal;
  int lx, ly, hx, hy;
  struct _room *room;
};

struct _junction {
  int v_or_h;
  struct _rect *rect0, *rect1; 
  struct _coord couner0, couner1;
};

struct _room {
  int lx, ly, hx, hy;
  gboolean route;
  gboolean monsterhouse;
};

struct _map {
  gboolean pass;
  gboolean waynavi;
  gboolean passed;
  gboolean disturb;
  struct _room *room;
};

struct _cave {
  struct _map map[MAP_W][MAP_H];
  GList *rect_header;
  GList *junction_header;
  GList *room_header;
};

void cave_generate_tutorial(struct _cave *c);
void cave_free(struct _cave *c);
void cave_generate(struct _cave *c);
#endif
