#include <glib.h>
#include <SDL.h>
#include "racanhack.h"
#include "task.h"
#include "video.h"
#include "cave.h"
#include "player.h"
#include "monster.h"
#include "object.h"
#include "stair.h"
#include "floor.h"

gboolean is_map_pass(struct _coord coord)
{
  return curf->cave.map[coord.x][coord.y].pass;
}

gboolean is_map_wall(struct _coord coord)
{
  return !(curf->cave.map[coord.x][coord.y].pass);
}

gboolean is_map_waynavi(struct _coord coord)
{
  return curf->cave.map[coord.x][coord.y].waynavi;
}

gboolean is_map_passed(struct _coord coord)
{
  return curf->cave.map[coord.x][coord.y].passed;
}

gboolean is_map_disturb(struct _coord coord)
{
  return curf->cave.map[coord.x][coord.y].disturb;
}

struct _room *at_room(struct _coord coord)
{
  return curf->cave.map[coord.x][coord.y].room;
}

struct _coord rand_coord_on_room()
{
  struct _room *room;
  struct _coord coord;
  int i;
  i = g_random_int_range(0, g_list_length(curf->cave.room_header));
  room = g_list_nth_data(curf->cave.room_header, i);
  coord.x = g_random_int_range(room->lx, room->hx + 1);
  coord.y = g_random_int_range(room->ly, room->hy + 1);
  if (is_object(coord) || is_stair(coord) || is_monster(coord)) {
    return rand_coord_on_room();
  };
  return coord;
}

void floor_init()
{
  floor_header = NULL;
}

void floor_free()
{
  GList *li;
  struct _floor *floor;
  for (li = g_list_first(floor_header); li != NULL; li = g_list_next(li)) {
    floor = (struct _floor *)li->data;
    cave_free(&floor->cave);
    g_list_foreach(floor->monster_header, (GFunc)my_free, NULL);
    g_list_free(floor->monster_header);
    g_list_foreach(floor->object_header, (GFunc)my_free, NULL);
    g_list_free(floor->object_header);
    g_list_foreach(floor->stair_header, (GFunc)my_free, NULL);
    g_list_free(floor->stair_header);
  };
  g_list_foreach(floor_header, (GFunc)my_free, NULL);
  g_list_free(floor_header);
}

struct _floor *floor_add()
{
  struct _floor *floor;
  floor = my_new(struct _floor, 1);
  cave_generate(&floor->cave);
  floor->monster_header = NULL;
  floor->object_header = NULL;
  floor->stair_header = NULL;
  floor_header = g_list_append(floor_header, floor);
  return(floor);
}

struct _floor *floor_tutorial_add()
{
  struct _floor *floor;
  floor = my_new(struct _floor, 1);
  cave_generate_tutorial(&floor->cave);
  floor->monster_header = NULL;
  floor->object_header = NULL;
  floor->stair_header = NULL;
  floor_header = g_list_append(floor_header, floor);
  return(floor);
}

void floor_curf_set(struct _floor *floor)
{
  curf = floor;
};

void floor_curf_store() 
{
  GList *li;
  struct _monster *monster;
  struct _object *object;
  struct _stair *stair;
  for (li = g_list_first(curf->monster_header); li != NULL; li = g_list_next(li)) {
    monster = (struct _monster *)li->data;
    monster->sprite->alive = FALSE;
    monster->sprite = NULL;
    monster->task->alive = FALSE;
    monster->task = NULL;
  };
  for (li = g_list_first(curf->object_header); li != NULL; li = g_list_next(li)) {
    object = (struct _object *)li->data;
    object->sprite->alive = FALSE;
    object->sprite = NULL;
    object->task->alive = FALSE;
    object->task = NULL;
  };
  for (li = g_list_first(curf->stair_header); li != NULL; li = g_list_next(li)) {
    stair = (struct _stair *)li->data;
    stair->sprite->alive = FALSE;
    stair->sprite = NULL;
    stair->task->alive = FALSE;
    stair->task = NULL;
  };
}

void floor_curf_restore() 
{
  GList *li;
  struct _monster *monster;
  struct _object *object;
  struct _stair *stair;
  for (li = g_list_first(curf->monster_header); li != NULL; li = g_list_next(li)) {
    monster = (struct _monster *)li->data;
    monster->sprite = video_sprite_add(MONSTER_SPRITE_Z_ORDER);
    monster->sprite->x = monster->coord.x * SPRITE_W;
    monster->sprite->y = monster->coord.y * SPRITE_H;
    monster_trans_state(monster_turn_end, monster);
  };
  for (li = g_list_first(curf->object_header); li != NULL; li = g_list_next(li)) {
    object = (struct _object *)li->data;
    object->sprite = video_sprite_add(OBJECT_SPRITE_Z_ORDER);
    object->sprite->x = SPRITE_W * object->coord.x;
    object->sprite->y = SPRITE_H * object->coord.y;
    object_trans_state(object_on_floor, object);
  };
  for (li = g_list_first(curf->stair_header); li != NULL; li = g_list_next(li)) {
    stair = (struct _stair *)li->data;
    stair->sprite = video_sprite_add(STAIR_SPRITE_Z_ORDER);
    stair->sprite->x = stair->coord.x * SPRITE_W;
    stair->sprite->y = stair->coord.y * SPRITE_H;
    stair_trans_state(stair_idle, stair);
  };
}
