#ifndef _PLAYER_H_
#define _PLAYER_H_

enum {
  MAPCHIPS_SPRITE_Z_ORDER = 0,
  OBJECT_SPRITE_Z_ORDER = 1,
  STAIR_SPRITE_Z_ORDER = 1,
  PLAYER_SPRITE_Z_ORDER = 2,
  MONSTER_SPRITE_Z_ORDER = 2,
  LOOKDOWN_SPRITE_Z_ORDER = 3
};

/*  y  k  u      7  8  9
 *   \ | /        \ | /
 *  h- . -l      4- . -6
 *   / | \        / | \
 *  b  j  n      1  2  3 */
 
/* Never forget that DIRECTION_X != X.
 * Player.direction = DIRECTION_2 stands for player face "down",
 * and then Player.direction == 1 is TRUE.
 * I think that it would be correct to write
 * struct _player {
 *   struct _coord coord;
 *   enum _direction direction;
 *   struct _status status; 
 *   ... */

enum {
  DIRECTION_1,
  DIRECTION_2,
  DIRECTION_3,
  DIRECTION_4,
  DIRECTION_5,
  DIRECTION_6,
  DIRECTION_7,
  DIRECTION_8,
  DIRECTION_9,
  DIRECTION_SUM
};

enum {
  MOTION = 8,
  PLAYER_LEV_MAX = 17,
  DODGED_DAMAGE = G_MAXUINT,
  PLAYER_FOOD_MAX = 100,
  INVENTORY_MAX = 22
};

enum {
  STATUS_NORMAL,
  STATUS_POISON,
  STATUS_SLEEP,
  STATUS_CONFUSE,
  STATUS_BLIND,
  STATUS_SLEEP_MONSTERHOUSE
};

struct _status {
  int type;
  int time;
};

struct _player {
  struct _coord coord;
  int direction;
  struct _status status;
  int exp;
  int lev;
  int mhp;
  int chp;
  int cstr;
  int mstr;
  int atk;
  int food;
  int food_count;
  int regen_count;
  guint damage;
  gchar died_from[32];
  struct _object *weapon;
  struct _object *shield;
  struct _object *arrow;
  struct _object *ring;
  GList *inventory_list;
  struct _sprite *sprite;
  struct _task *task;
};

struct _player Player;
int lev_exp_table[PLAYER_LEV_MAX];
SDL_Surface *surface_player_idle[DIRECTION_SUM][ANIME_J];
SDL_Surface *surface_player_attack[DIRECTION_SUM][ANIME_J];
SDL_Surface *surface_player_damage[DIRECTION_SUM][ANIME_J];

int motion_end(struct _task *task);
int ddd(int i);
int ddx(int d);
int ddy(int d);
int lefthand(int count, int direction);
int opposite(int direction);
struct _coord coord_dd(struct _coord cur_coord, int direction);
int distance(struct _coord c1, struct _coord c2);
int animecount(struct _task *task);
void take_hit(struct _player *player, guint damage, const gchar *format, ...);
gboolean is_passable(struct _coord coord, int direction);
void disturb();
void player_trans_state(task_func (*fp)(struct _task *task), struct _player *player);
struct _player *is_player(struct _coord coord);
void player_init();
void player_free();
struct _player *player_add();
task_func player_turn_start(struct _task *task);
task_func player_action_start(struct _task *task);
task_func player_action_end(struct _task *task);
task_func player_turn_end(struct _task *task);
task_func player_move(struct _task *task);
task_func move_player_anime(struct _task *task);
task_func player_move_running(struct _task *task);
task_func player_attack(struct _task *task);
task_func player_fire_arrow(struct _task *task);
task_func player_pickup(struct _task *task);
task_func player_down_stair(struct _task *task);
task_func player_up_stair(struct _task *task);
task_func player_lev_up(struct _task *task);
task_func player_get_amulet_of_yendor(struct _task *task);
task_func player_killed(struct _task *task);
#endif
